/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.conversion;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.mvel2.ConversionException;
import org.mvel2.ConversionHandler;
import org.mvel2.DataConversion;
import org.mvel2.conversion.Converter;
import org.mvel2.util.ParseTools;

public class PrimArrayHandler
implements ConversionHandler {
    private final Map<Class, Converter> CNV = new HashMap<Class, Converter>();
    private final Class primitiveType;

    public PrimArrayHandler(Class type) {
        this.primitiveType = ParseTools.getBaseComponentType(type);
    }

    public Object convertFrom(Object in) {
        return PrimArrayHandler.handleLooseTypeConversion(in.getClass(), in, this.primitiveType);
    }

    public boolean canConvertFrom(Class cls) {
        return cls.isArray();
    }

    private static Object handleLooseTypeConversion(Class sourceType, Object input, Class targetType) {
        Class targType = ParseTools.getBaseComponentType(targetType);
        int len = Array.getLength(input);
        Object target = Array.newInstance(targType, len);
        if (len > 0 && DataConversion.canConvert(targetType, ParseTools.getBaseComponentType(sourceType))) {
            for (int i = 0; i < len; ++i) {
                Array.set(target, i, DataConversion.convert(Array.get(input, i), targType));
            }
        } else {
            throw new ConversionException("cannot convert to type: " + targetType.getComponentType().getName() + "[] from " + ParseTools.getBaseComponentType(sourceType).getName());
        }
        return target;
    }
}

