/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import org.mvel2.CompileException;
import org.mvel2.DataConversion;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.PropertyAccessor;
import org.mvel2.ast.ASTNode;
import org.mvel2.ast.ArraySize;
import org.mvel2.ast.TypeDescriptor;
import org.mvel2.compiler.AbstractParser;
import org.mvel2.compiler.Accessor;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.AccessorOptimizer;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.util.ArrayTools;
import org.mvel2.util.ParseTools;

public class NewObjectNode
extends ASTNode {
    private transient Accessor newObjectOptimizer;
    private TypeDescriptor typeDescr;
    private static final Class[] EMPTYCLS = new Class[0];

    public NewObjectNode(char[] expr, int fields, ParserContext pCtx) {
        this.name = expr;
        this.fields = fields;
        this.typeDescr = new TypeDescriptor(expr, this.fields);
        if ((fields & 0x10) != 0) {
            if (pCtx != null && pCtx.hasImport(this.typeDescr.getClassName())) {
                pCtx.setAllowBootstrapBypass(false);
                this.egressType = pCtx.getImport(this.typeDescr.getClassName());
            } else {
                try {
                    this.egressType = Thread.currentThread().getContextClassLoader().loadClass(this.typeDescr.getClassName());
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            if (this.egressType != null) {
                this.rewriteClassReferenceToFQCN(fields);
                if (this.typeDescr.isArray()) {
                    try {
                        this.egressType = ParseTools.findClass(null, ParseTools.repeatChar('[', this.typeDescr.getArrayLength()) + "L" + this.egressType.getName() + ";", pCtx);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private void rewriteClassReferenceToFQCN(int fields) {
        String FQCN = this.egressType.getName();
        if (this.typeDescr.getClassName().indexOf(46) == -1) {
            int idx = ArrayTools.findFirst('(', this.name);
            char[] fqcn = FQCN.toCharArray();
            if (idx == -1) {
                idx = fqcn.length;
                this.name = new char[idx];
                for (int i = 0; i < idx; ++i) {
                    this.name[i] = fqcn[i];
                }
            } else {
                char[] newName = new char[fqcn.length + (this.name.length - idx)];
                for (int i = 0; i < fqcn.length; ++i) {
                    newName[i] = fqcn[i];
                }
                int i0 = this.name.length - idx;
                int i1 = fqcn.length;
                for (int i = 0; i < i0; ++i) {
                    newName[i + i1] = this.name[i + idx];
                }
                this.name = newName;
            }
            this.typeDescr.updateClassName(this.name, fields);
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.newObjectOptimizer == null) {
            if (this.egressType == null && factory != null && factory.isResolveable(this.typeDescr.getClassName())) {
                try {
                    this.egressType = (Class)factory.getVariableResolver(this.typeDescr.getClassName()).getValue();
                    this.rewriteClassReferenceToFQCN(16);
                    if (this.typeDescr.isArray()) {
                        try {
                            this.egressType = ParseTools.findClass(factory, ParseTools.repeatChar('[', this.typeDescr.getArrayLength()) + "L" + this.egressType.getName() + ";", null);
                        }
                        catch (Exception e) {}
                    }
                }
                catch (ClassCastException e) {
                    throw new CompileException("cannot construct object: " + this.typeDescr.getClassName() + " is not a class reference", e);
                }
            }
            if (this.typeDescr.isArray()) {
                this.newObjectOptimizer = new NewObjectArray(ParseTools.getBaseComponentType(this.egressType.getComponentType()), this.typeDescr.getCompiledArraySize());
                return this.newObjectOptimizer.getValue(ctx, thisValue, factory);
            }
            AccessorOptimizer optimizer = OptimizerFactory.getThreadAccessorOptimizer();
            this.newObjectOptimizer = optimizer.optimizeObjectCreation(AbstractParser.getCurrentThreadParserContext(), this.name, ctx, thisValue, factory);
            if (optimizer.getResultOptPass() != null) {
                this.egressType = optimizer.getEgressType();
                return optimizer.getResultOptPass();
            }
        }
        return this.newObjectOptimizer.getValue(ctx, thisValue, factory);
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        try {
            if (this.typeDescr.isArray()) {
                Class cls = ParseTools.findClass(factory, this.typeDescr.getClassName(), null);
                int[] s = new int[this.typeDescr.getArrayLength()];
                ArraySize[] arraySize = this.typeDescr.getArraySize();
                for (int i = 0; i < s.length; ++i) {
                    s[i] = DataConversion.convert(MVEL.eval(arraySize[i].value, ctx, factory), Integer.class);
                }
                return Array.newInstance(cls, s);
            }
            String[] cnsRes = ParseTools.captureContructorAndResidual(this.name);
            String[] constructorParms = ParseTools.parseMethodOrConstructor(cnsRes[0].toCharArray());
            if (constructorParms != null) {
                Class cls = ParseTools.findClass(factory, new String(ParseTools.subset(this.name, 0, ArrayTools.findFirst('(', this.name))), null);
                Object[] parms = new Object[constructorParms.length];
                for (int i = 0; i < constructorParms.length; ++i) {
                    parms[i] = MVEL.eval(constructorParms[i], ctx, factory);
                }
                Constructor cns = ParseTools.getBestConstructorCanadidate(parms, cls);
                if (cns == null) {
                    throw new CompileException("unable to find constructor for: " + cls.getName());
                }
                for (int i = 0; i < parms.length; ++i) {
                    parms[i] = DataConversion.convert(parms[i], cns.getParameterTypes()[i]);
                }
                if (cnsRes.length > 1) {
                    return PropertyAccessor.get(cnsRes[1], cns.newInstance(parms), factory, thisValue);
                }
                return cns.newInstance(parms);
            }
            Constructor<?> cns = Thread.currentThread().getContextClassLoader().loadClass(this.typeDescr.getClassName()).getConstructor(EMPTYCLS);
            if (cnsRes.length > 1) {
                return PropertyAccessor.get(cnsRes[1], cns.newInstance(new Object[0]), factory, thisValue);
            }
            return cns.newInstance(new Object[0]);
        }
        catch (CompileException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw new CompileException("unable to resolve class: " + e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new CompileException("cannot resolve constructor: " + e.getMessage());
        }
        catch (Exception e) {
            throw new CompileException("could not instantiate class: " + e.getMessage());
        }
    }

    public Accessor getNewObjectOptimizer() {
        return this.newObjectOptimizer;
    }

    public TypeDescriptor getTypeDescr() {
        return this.typeDescr;
    }

    public static class NewObjectArray
    implements Accessor,
    Serializable {
        private ExecutableStatement[] sizes;
        private Class arrayType;

        public NewObjectArray(Class arrayType, ExecutableStatement[] sizes) {
            this.arrayType = arrayType;
            this.sizes = sizes;
        }

        public Object getValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory) {
            int[] s = new int[this.sizes.length];
            for (int i = 0; i < s.length; ++i) {
                s[i] = DataConversion.convert(this.sizes[i].getValue(ctx, elCtx, variableFactory), Integer.class);
            }
            return Array.newInstance(this.arrayType, s);
        }

        public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
            return null;
        }

        public Class getKnownEgressType() {
            try {
                return Class.forName("[L" + this.arrayType.getName() + ";");
            }
            catch (ClassNotFoundException cne) {
                return null;
            }
        }
    }
}

