package org.mule.weave.v2.api.tooling.ts

trait DWTypeVisitor {
  def visit(dataWeaveType: DWType): Unit = {
    // Nothing to do
  }

  def visitTypeType(typeType: TypeType): Unit = visit(typeType)

  def visitLocalDateType(localDateType: LocalDateType): Unit = visit(localDateType)

  def visitNameValuePairType(nameValuePairType: NameValuePairType): Unit = visit(nameValuePairType)

  def visitNumberType(numberType: NumberType): Unit = visit(numberType)

  def visitObjectType(objectType: ObjectType): Unit = visit(objectType)

  def visitRangeType(rangeType: RangeType): Unit = visit(rangeType)

  def visitDateTimeType(dateTimeType: DateTimeType): Unit = visit(dateTimeType)

  def visitKeyType(keyType: KeyType): Unit = visit(keyType)

  def visitNameType(nameType: NameType): Unit = visit(nameType)

  def visitUriType(uriType: UriType): Unit = visit(uriType)

  def visitArrayType(arrayType: ArrayType): Unit = visit(arrayType)

  def visitLocalDateTimeType(localDateTimeType: LocalDateTimeType): Unit = visit(localDateTimeType)

  def visitSimpleReferenceType(simpleReferenceType: SimpleReferenceType): Unit = visit(simpleReferenceType)

  def visitTypeSelectorType(typeSelectorType: TypeSelectorType): Unit = visit(typeSelectorType)

  def visitNamespaceType(namespaceType: NamespaceType): Unit = visit(namespaceType)

  def visitPeriodType(periodType: PeriodType): Unit = visit(periodType)

  def visitIntersectionType(interSectionType: IntersectionType): Unit = visit(interSectionType)

  def visitKeyValuePairType(keyValuePairType: KeyValuePairType): Unit = visit(keyValuePairType)

  def visitTimeZoneType(timeZoneType: TimeZoneType): Unit = visit(timeZoneType)

  def visitNothingType(nothingType: NothingType): Unit = visit(nothingType)

  def visitNullType(nullType: NullType): Unit = visit(nullType)

  def visitTimeType(timeType: TimeType): Unit = visit(timeType)

  def visitBinaryType(binaryType: BinaryType): Unit = visit(binaryType)

  def visitBooleanType(booleanType: BooleanType): Unit = visit(booleanType)

  def visitUnionType(interSectionType: UnionType): Unit = visit(interSectionType)

  def visitRegexType(regexType: RegexType): Unit = visit(regexType)

  def visitTypeParameter(typeParameterType: TypeParameter): Unit = visit(typeParameterType)

  def visitLocalTimeType(localTimeType: LocalTimeType): Unit = visit(localTimeType)

  def visitDynamicReturnType(dynamicReturnType: DynamicReturnType): Unit = visit(dynamicReturnType)

  def visitAnyType(anyType: AnyType): Unit = visit(anyType)

  def visitStringType(stringType: StringType): Unit = visit(stringType)

  def visitFunctionType(functionType: FunctionType): Unit = visit(functionType)
}
