package org.mule.weave.v2.api.tooling.location

/**
  * Represents the location within a script.
  */
trait Location {
  /**
    * @return the start [[Position]].
    */
  def getStartPosition: Position

  /**
    * @return the end [[Position]].
    */
  def getEndPosition: Position

  /**
    * @return the [[ResourceIdentifier]].
    */
  def getResourceIdentifier: ResourceIdentifier

  /**
    * @return a [[String]] representation for this location.
    */
  def toStringRepresentation: String
}

/**
  * Represents the position within a script.
  */
trait Position {
  /**
    * @return The index within the current script.
    */
  def getIndex: Int

  /**
    * @return The line within the current script.
    */
  def getLine: Int

  /**
    * @return The column within the current script.
    */
  def getColumn: Int

  /**
    * @return The source of the current script.
    */
  def getSource: String
}

/**
  * Represents the identifier of a resource.
  */
trait ResourceIdentifier {

  /**
    * @return the fully qualified name of the identifier.
    */
  def getFQNIdentifier: String
}