package org.mule.weave.v2.api.tooling.ast

import org.mule.weave.v2.api.tooling.location.Location
import org.mule.weave.v2.api.tooling.ts.DWType

import java.util.Optional

/**
  * Represent an AST (Abstract Syntax Tree) for a script.
  */
trait DWAstNode {

  /**
    * @return Returns the [[DWAstNode]] declaration to which this node points, if exists.
    */
  def getReference: Optional[DWAstNode]

  /**
    * @return Returns the [[DWType]] of this node, if exists.
    */
  def getTypeOf: Optional[DWType]

  /**
    * @return The list of [[DWAstNode]] children.
    */
  def getChildren: Array[DWAstNode]

  /**
    * @return The kind of this node. See [[DWAstNodeKind]]
    */
  def getKind: String

  /**
    * @return the value of this node (for leaf nodes)
    */
  def getValue: Optional[String]

  /**
    * @return The DataWeave code representation of this node.
    */
  def emitCode(): String

  /**
    * @return The [[DWAstNode]] parent of this node if exits.
    */
  def getParent: Optional[DWAstNode]

  /**
    * @return The [[Location]] of this node in the DataWeave code.
    */
  def getLocation: Location

  /**
    * @return The [[DWAstNode]] that represents the documentation of this node in the DataWeave code.
    */
  def getDocumentation: Optional[DWAstNode]
}

/**
  * A utility class with the catalog of [[DWAstNode]] kinds.
  */
object DWAstNodeKind {
  /**
    * Variable used to identify a `NameIdentifier` AST node.
    */
  val NAME_IDENTIFIER = "NameIdentifier"

  /**
    * Variable used to identify a `BooleanNode` AST node.
    */
  val BOOLEAN_NODE = "BooleanNode"

  /**
    * Variable used to identify a `NumberNode` AST node.
    */
  val NUMBER_NODE = "NumberNode"

  /**
    * Variable used to identify a `StringNode` AST node.
    */
  val STRING_NODE = "StringNode"

  /**
    * Variable used to identify an `ArrayNode` AST node.
    */
  val ARRAY_NODE = "ArrayNode"

  /**
    * Variable used to identify a `KeyNode` AST node.
    */
  val KEY_NODE = "KeyNode"

  /**
    * Variable used to identify a `KeyValuePairNode` AST node.
    */
  val KEY_VALUE_PAIR_NODE = "KeyValuePairNode"

  /**
    * Variable used to identify an `ObjectNode` AST node.
    */
  val OBJECT_NODE = "ObjectNode"

  /**
    * Variable used to identify an `AnnotationArgumentNode` AST node.
    */
  val ANNOTATION_ARGUMENT_NODE = "AnnotationArgumentNode"

  /**
    * Variable used to identify an `AnnotationNode` AST node.
    */
  val ANNOTATION_NODE = "AnnotationNode"

  /**
    * Variable used to identify a `FunctionDirectiveNode` AST node.
    */
  val FUNCTION_DIRECTIVE_NODE = "FunctionDirectiveNode"

  /**
    * Variable used to identify a `ParametersDocNode` AST node.
    */
  val PARAMETERS_DOC_NODE = "ParametersDocNode"

  /**
    * Variable used to identify a `MoreExamplesSectionNode` AST node.
    */
  val MORE_EXAMPLES_DOC_NODE = "MoreExamplesSectionNode"

  /**
    * Variable used to identify a `ExampleSectionNode` AST node.
    */
  val EXAMPLE_SECTION_DOC_NODE = "ExampleSectionNode"

  /**
    * Variable used to identify a `TypeParameterApplicationListNode` AST node.
    */
  val TYPE_PARAMETER_APPLICATION_LIST_NODE = "TypeParameterApplicationListNode"

  /**
    * Variable used to identify a `OverloadedFunctionNode` AST node.
    */
  val OVERLOADED_FUNCTION_NODE = "OverloadedFunctionNode"

  /**
    * Variable used to identify a `DoBlockNode` AST node.
    */
  val DO_BLOCK_NODE = "DoBlockNode"

  /**
    * Variable used to identify a `DocumentNode` AST node.
    */
  val DOCUMENT_NODE = "DocumentNode"

  /**
    * Variable used to identify a `ModuleNode` AST node.
    */
  val MODULE_NODE = "ModuleNode"

  /**
    * Variable used to identify a `ContentTypeNode` AST node.
    */
  val CONTENT_TYPE_NODE = "ContentTypeNode"

  /**
    * Variable used to identify a `MissingFormatNode` AST node.
    */
  val MISSING_FORMAT_NODE = "MissingFormatNode"

  /**
    * Variable used to identify a `DataFormatIdNode` AST node.
    */
  val DATA_FORMAT_ID_NODE = "DataFormatIdNode"

  /**
    * Variable used to identify a `MissingDataFormatNode` AST node.
    */
  val MISSING_DATA_FORMAT = "MissingDataFormatNode"

  /**
    * Variable used to identify a `NameNode` AST node.
    */
  val NAME_NODE = "NameNode"

  /**
    * Variable used to identify a `MissingKeySelectorNode` AST node.
    */
  val MISSING_KEY_SELECTOR_NODE = "MissingKeySelectorNode"

  /**
    * Variable used to identify a `HeadTailObjectNode` AST node.
    */
  val HEAD_TAIL_OBJECT_NODE = "HeadTailObjectNode"

  /**
    * Variable used to identify a `AndNode` AST node.
    */
  val AND_NODE = "AndNode"

  /**
    * Variable used to identify a `UpdateNode` AST node.
    */
  val UPDATE_NODE = "UpdateNode"

  /**
    * Variable used to identify a `BinaryOpNode` AST node.
    */
  val BINARY_OP_NODE = "BinaryOpNode"

  /**
    * Variable used to identify a `UnaryOpNode` AST node.
    */
  val UNARY_OP_NODE = "UnaryOpNode"

  /**
    * Variable used to identify a `UnlessNode` AST node.
    */
  val UNLESS_NODE = "UnlessNode"

  /**
    * Variable used to identify a `HeadTailArrayNode` AST node.
    */
  val HEAD_TAIL_ARRAY_NODE = "HeadTailArrayNode"

  /**
    * Variable used to identify a `UsingNode` AST node.
    */
  val USING_NODE = "UsingNode"

  /**
    * Variable used to identify a `VariableReferenceNode` AST node.
    */
  val VARIABLE_REFERENCE_NODE = "VariableReferenceNode"

  /**
    * Variable used to identify a `PatternMatcherNode` AST node.
    */
  val PATTERN_MATCHER_NODE = "PatternMatcherNode"

  /**
    * Variable used to identify a `FunctionCallNode` AST node.
    */
  val FUNCTION_CALL_NODE = "FunctionCallNode"

  /**
    * Variable used to identify a `DefaultNode` AST node.
    */
  val DEFAULT_NODE = "DefaultNode"

  /**
    * Variable used to identify a `OrNode` AST node.
    */
  val OR_NODE = "OrNode"

  /**
    * Variable used to identify a `LocalDateTimeNode` AST node.
    */
  val LOCAL_DATE_TIME_NODE = "LocalDateTimeNode"

  /**
    * Variable used to identify a `DateTimeNode` AST node.
    */
  val DATE_TIME_NODE = "DateTimeNode"

  /**
    * Variable used to identify a `PeriodNode` AST node.
    */
  val PERIOD_NODE = "PeriodNode"

  /**
    * Variable used to identify a `RegexNode` AST node.
    */
  val REGEX_NODE = "RegexNode"

  /**
    * Variable used to identify a `TimeZoneNode` AST node.
    */
  val TIMEZONE_NODE = "TimeZoneNode"

  /**
    * Variable used to identify a `NullNode` AST node.
    */
  val NULL_NODE = "NullNode"

  /**
    * Variable used to identify a `TimeNode` AST node.
    */
  val TIME_NODE = "TimeNode"

  /**
    * Variable used to identify a `LocalDateNode` AST node.
    */
  val LOCAL_DATE_NODE = "LocalDateNode"

  /**
    * Variable used to identify a `UriNode` AST node.
    */
  val URI_NODE = "UriNode"

  /**
    * Variable used to identify a `MissingUriNode` AST node.
    */
  val MISSING_URI_NODE = "MissingUriNode"

  /**
    * Variable used to identify a `IfNode` AST node.
    */
  val IF_NODE = "IfNode"

  /**
    * Variable used to identify a `VarDirectiveNode` AST node.
    */
  val VAR_DIRECTIVE_NODE = "VarDirectiveNode"

  /**
    * Variable used to identify a `ErrorDirectiveNode` AST node.
    */
  val ERROR_DIRECTIVE_NODE = "ErrorDirectiveNode"

  /**
    * Variable used to identify a `ImportDirectiveNode` AST node.
    */
  val IMPORT_DIRECTIVE_NODE = "ImportDirectiveNode"

  /**
    * Variable used to identify a `AnnotationDirectiveNode` AST node.
    */
  val ANNOTATION_DIRECTIVE_NODE = "AnnotationDirectiveNode"

  /**
    * Variable used to identify a `VersionDirectiveNode` AST node.
    */
  val VERSION_DIRECTIVE_NODE = "VersionDirectiveNode"

  /**
    * Variable used to identify a `NamespaceDirectiveNode` AST node.
    */
  val NAMESPACE_DIRECTIVE_NODE = "NamespaceDirectiveNode"

  /**
    * Variable used to identify a `TypeDirectiveNode` AST node.
    */
  val TYPE_DIRECTIVE_NODE = "TypeDirectiveNode"

  /**
    * Variable used to identify a `OutputDirectiveNode` AST node.
    */
  val OUTPUT_DIRECTIVE_NODE = "OutputDirectiveNode"

  /**
    * Variable used to identify a `InputDirectiveNode` AST node.
    */
  val INPUT_DIRECTIVE_NODE = "InputDirectiveNode"

  /**
    * Variable used to identify a `UnionTypeNode` AST node.
    */
  val UNION_TYPE_NODE = "UnionTypeNode"

  /**
    * Variable used to identify a `FunctionTypeNode` AST node.
    */
  val FUNCTION_TYPE_NODE = "FunctionTypeNode"

  /**
    * Variable used to identify a `KeyTypeNode` AST node.
    */
  val KEY_TYPE_NODE = "KeyTypeNode"

  /**
    * Variable used to identify a `NameTypeNode` AST node.
    */
  val NAME_TYPE_NODE = "NameTypeNode"

  /**
    * Variable used to identify a `ObjectTypeNode` AST node.
    */
  val OBJECT_TYPE_NODE = "ObjectTypeNode"

  /**
    * Variable used to identify a `TypeSelectorNode` AST node.
    */
  val TYPE_SELECTOR_NODE = "TypeSelectorNode"

  /**
    * Variable used to identify a `LiteralTypeNode` AST node.
    */
  val LITERAL_TYPE_NODE = "LiteralTypeNode"

  /**
    * Variable used to identify a `TypeReferenceNode` AST node.
    */
  val TYPE_REFERENCE_NODE = "TypeReferenceNode"

  /**
    * Variable used to identify a `IntersectionTypeNode` AST node.
    */
  val INTERSECTION_TYPE_NODE = "IntersectionTypeNode"

  /**
    * Variable used to identify a `FunctionParameterTypeNode` AST node.
    */
  val FUNCTION_PARAMETER_TYPE_NODE = "FunctionParameterTypeNode"

  /**
    * Variable used to identify a `KeyValuePairTypeNode` AST node.
    */
  val KEY_VALUE_PAIR_TYPE_NODE = "KeyValuePairTypeNode"

  /**
    * Variable used to identify a `DynamicReturnTypeNode` AST node.
    */
  val DYNAMIC_RETURN_TYPE_NODE = "DynamicReturnTypeNode"

  /**
    * Variable used to identify a `NativeTypeNode` AST node.
    */
  val NATIVE_TYPE_NODE = "NativeTypeNode"

  /**
    * Variable used to identify a `NameValueTypeNode` AST node.
    */
  val NAME_VALUE_TYPE_NODE = "NameValueTypeNode"

  /**
    * Variable used to identify a `TypeParameterNode` AST node.
    */
  val TYPE_PARAMETER_NODE = "TypeParameterNode"

  /**
    * Variable used to identify a `SchemaNode` AST node.
    */
  val SCHEMA_NODE = "SchemaNode"

  /**
    * Variable used to identify a `MissingSchemaNode` AST node.
    */
  val MISSING_SCHEMA_NODE = "MissingSchemaNode"

  /**
    * Variable used to identify a `FunctionNode` AST node.
    */
  val FUNCTION_NODE = "FunctionNode"

  /**
    * Variable used to identify a `AnnotationParameterNode` AST node.
    */
  val ANNOTATION_PARAMETER_NODE = "AnnotationParameterNode"

  /**
    * Variable used to identify a `ExistsSelectorNode` AST node.
    */
  val EXISTS_SELECTOR_NODE = "ExistsSelectorNode"

  /**
    * Variable used to identify a `DynamicKeyNode` AST node.
    */
  val DYNAMIC_KEY_NODE = "DynamicKeyNode"

  /**
    * Variable used to identify a `ParameterNode` AST node.
    */
  val PARAMETER_NODE = "ParameterNode"

  /**
    * Variable used to identify a `LiteralPatterNode` AST node.
    */
  val LITERAL_PATTERN_NODE = "LiteralPatterNode"

  /**
    * Variable used to identify a `RegexPatternNode` AST node.
    */
  val REGEX_PATTERN_NODE = "RegexPatternNode"

  /**
    * Variable used to identify a `DefaultPatternNode` AST node.
    */
  val DEFAULT_PATTERN_NODE = "DefaultPatternNode"

  /**
    * Variable used to identify a `EmptyObjectPatternNode` AST node.
    */
  val EMPTY_OBJECT_PATTERN_NODE = "EmptyObjectPatternNode"

  /**
    * Variable used to identify a `TypePatterNode` AST node.
    */
  val TYPE_PATTERN_NODE = "TypePatterNode"

  /**
    * Variable used to identify a `ExpressionPatternNode` AST node.
    */
  val EXPRESSION_PATTERN_NODE = "ExpressionPatternNode"

  /**
    * Variable used to identify a `DeconstructArrayPatternNode` AST node.
    */
  val DECONSTRUCT_ARRAY_PATTERN_NODE = "DeconstructArrayPatternNode"

  /**
    * Variable used to identify a `EmptyArrayPatternNode` AST node.
    */
  val EMPTY_ARRAY_PATTERN_NODE = "EmptyArrayPatternNode"

  /**
    * Variable used to identify a `EmptyArrayPatternNode` AST node.
    */
  val DECONSTRUCT_OBJECT_PATTERN_NODE = "EmptyArrayPatternNode"

  /**
    * Variable used to identify a `NamespaceNode` AST node.
    */
  val NAMESPACE_NODE = "NamespaceNode"

  /**
    * Variable used to identify a `DynamicNameNode` AST node.
    */
  val DYNAMIC_NAME_NODE = "DynamicNameNode"

  /**
    * Variable used to identify a `VersionMajorNode` AST node.
    */
  val VERSION_MAJOR_NODE = "VersionMajorNode"

  /**
    * Variable used to identify a `MissingVersionMajorNode` AST node.
    */
  val MISSING_VERSION_MAJOR_NODE = "MissingVersionMajorNode"

  /**
    * Variable used to identify a `ImportedElementsNode` AST node.
    */
  val IMPORTED_ELEMENTS_NODE = "ImportedElementsNode"

  /**
    * Variable used to identify a `OutputExampleSectionNode` AST node.
    */
  val OUTPUT_EXAMPLE_SECTION_NODE = "OutputExampleSectionNode"

  /**
    * Variable used to identify a `InputExampleSectionNode` AST node.
    */
  val INPUT_EXAMPLE_SECTION_NODE = "InputExampleSectionNode"

  /**
    * Variable used to identify a `SourceExampleSectionNode` AST node.
    */
  val SOURCE_EXAMPLE_SECTION_NODE = "SourceExampleSectionNode"

  /**
    * Variable used to identify a `DirectiveOptionNode` AST node.
    */
  val DIRECTIVE_OPTION_NODE = "DirectiveOptionNode"

  /**
    * Variable used to identify a `DirectiveOptionNameNode` AST node.
    */
  val DIRECTIVE_OPTION_NAME_NODE = "DirectiveOptionNameNode"

  /**
    * Variable used to identify a `TypeParameterListNode` AST node.
    */
  val TYPE_PARAMETER_LIST_NODE = "TypeParameterListNode"

  /**
    * Variable used to identify a `DescriptionNode` AST node.
    */
  val DESCRIPTION_NODE = "DescriptionNode"

  /**
    * Variable used to identify a `CodeBlockNode` AST node.
    */
  val CODE_BLOCK_NODE = "CodeBlockNode"

  /**
    * Variable used to identify a `TextContentNode` AST node.
    */
  val TEXT_CONTENT_NODE = "TextContentNode"

  /**
    * Variable used to identify a `CodeBlockInfoNode` AST node.
    */
  val CODE_BLOCK_INFO_NODE = "CodeBlockInfoNode"

  /**
    * Variable used to identify a `VersionMinorNode` AST node.
    */
  val VERSION_MINOR_NODE = "VersionMinorNode"

  /**
    * Variable used to identify a `MissingVersionMinorNode` AST node.
    */
  val MISSING_VERSION_MINOR_NODE = "MissingVersionMinorNode"

  /**
    * Variable used to identify a `StringInterpolationNode` AST node.
    */
  val STRING_INTERPOLATION_NODE = "StringInterpolationNode"

  /**
    * Variable used to identify a `AttributedNode` AST node.
    */
  val ATTRIBUTES_NODE = "AttributedNode"

  /**
    * Variable used to identify a `ArrayIndexUpdateSelectorNode` AST node.
    */
  val ARRAY_INDEX_UPDATE_SELECTOR_NODE = "ArrayIndexUpdateSelectorNode"

  /**
    * Variable used to identify a `AttributeNameUpdateSelectorNode` AST node.
    */
  val ATTRIBUTE_NAME_UPDATE_SELECTOR_NODE = "AttributeNameUpdateSelectorNode"

  /**
    * Variable used to identify a `MultiFieldUpdateSelectorNode` AST node.
    */
  val MULTI_FIELD_NAME_UPDATE_SELECTOR_NODE = "MultiFieldUpdateSelectorNode"

  /**
    * Variable used to identify a `FieldUpdateSelectorNode` AST node.
    */
  val FIELD_NAME_UPDATE_SELECTOR_NODE = "FieldUpdateSelectorNode"

  /**
    * Variable used to identify a `AnnotationArgumentsNode` AST node.
    */
  val ANNOTATION_ARGUMENTS_NODE = "AnnotationArgumentsNode"

  /**
    * Variable used to identify a `FunctionCallParametersNode` AST node.
    */
  val FUNCTION_CALL_PARAMETERS_NODE = "FunctionCallParametersNode"

  /**
    * Variable used to identify a `NullUnsafeNode` AST node.
    */
  val NULL_UNSAFE_NODE = "NullUnsafeNode"

  /**
    * Variable used to identify a `FunctionParametersNode` AST node.
    */
  val FUNCTION_PARAMETERS_NODE = "FunctionParametersNode"

  /**
    * Variable used to identify a `ImportedElementNode` AST node.
    */
  val IMPORTED_ELEMENT_NODE = "ImportedElementNode"

  /**
    * Variable used to identify a `FunctionParameterNode` AST node.
    */
  val FUNCTION_PARAMETER_NODE = "FunctionParameterNode"

  /**
    * Variable used to identify a `MissingFunctionParameterNode` AST node.
    */
  val MISSING_FUNCTION_PARAMETER = "MissingFunctionParameterNode"

  /**
    * Variable used to identify a `NullSafeNode` AST node.
    */
  val NULL_SAFE_NODE = "NullSafeNode"

  /**
    * Variable used to identify a `Header` AST node.
    */
  val HEADER = "Header"

  /**
    * Variable used to identify a `HeaderNode` AST node.
    */
  val HEADER_NODE = "HeaderNode"

  /**
    * Variable used to identify a `UndefinedExpressionNode` AST node.
    */
  val UNDEFINED_EXPRESSION_NODE = "UndefinedExpressionNode"

  /**
    * Variable used to identify a `AnnotationParametersNode` AST node.
    */
  val ANNOTATION_PARAMETERS_NODE = "AnnotationParametersNode"

  /**
    * Variable used to identify a `CommentNode` AST node.
    */
  val COMMENT_NODE = "CommentNode"

  /**
    * Variable used to identify a `MissingTokenErrorASTNode` AST node.
    */
  val MISSING_TOKEN_ERROR_NODE = "MissingTokenErrorASTNode"

  /**
    * Variable used to identify a `MissingSelectorExpressionErrorNode` AST node.
    */
  val MISSING_SELECTOR_EXPRESSION_ERROR_NODE = "MissingSelectorExpressionErrorNode"

  /**
    * Variable used to identify a `InvalidFieldNameIdentifierNode` AST node.
    */
  val INVALID_FIELD_NAME_IDENTIFIER_NODE = "InvalidFieldNameIdentifierNode"

  /**
    * Variable used to identify a `MissingNameIdentifierNode` AST node.
    */
  val MISSING_NAME_IDENTIFIER_NODE = "MissingNameIdentifierNode"

  /**
    * Variable used to identify a `MissingFunctionDefinitionErrorNode` AST node.
    */
  val MISSING_FUNCTION_DEFINITION_ERROR_NODE = "MissingFunctionDefinitionErrorNode"

  /**
    * Variable used to identify a `InvalidVariableNameIdentifierErrorNode` AST node.
    */
  val INVALID_VARIABLE_NAME_IDENTIFIER_ERROR_NODE = "InvalidVariableNameIdentifierErrorNode"

  /**
    * Variable used to identify a `MissingExpressionErrorNode` AST node.
    */
  val MISSING_EXPRESSION_ERROR_NODE = "MissingExpressionErrorNode"

  /**
    * Variable used to identify a `InvalidNameIdentifierError` AST node.
    */
  val INVALID_NAME_IDENTIFIER_ERROR = "InvalidNameIdentifierError"

  /**
    * Variable used to identify a `UpdateExpressionsNode` AST node.
    */
  val UPDATE_EXPRESSIONS_NODE = "UpdateExpressionsNode"

  /**
    * Variable used to identify a `UpdateExpressionNode` AST node.
    */
  val UPDATE_EXPRESSION_NODE = "UpdateExpressionNode"

  /**
    * Variable used to identify a `UsingVariableAssignmentsNode` AST node.
    */
  val USING_VARIABLE_ASSIGNMENTS_NODE = "UsingVariableAssignmentsNode"

  /**
    * Variable used to identify a `UsingVariableAssignmentNode` AST node.
    */
  val USING_VARIABLE_ASSIGNMENT_NODE = "UsingVariableAssignmentNode"

  /**
    * Variable used to identify a `ConditionalNode` AST node.
    */
  val CONDITIONAL_NODE = "ConditionalNode"

  /**
    * Variable used to identify a `LocalTimeNode` AST node.
    */
  val LOCAL_TIME_NODE = "LocalTimeNode"

  /**
    * Variable used to identify a `NameValuePairNode` AST node.
    */
  val NAME_VALUE_PAIR_NODE = "NameValuePairNode"

  /**
    * Variable used to identify a `SchemaPropertyNode` AST node.
    */
  val SCHEMA_PROPERTY_NODE = "SchemaPropertyNode"

  /**
    * Variable used to identify a `ExpressionsPatternNode` AST node.
    */
  val EXPRESSIONS_PATTERN_NODE = "ExpressionsPatternNode"
}