package org.mule.weave.v2.runtime.utils

object WeaveRunner extends App {

  main()

  def main() {
    if (args.isEmpty) {
      printUsages
    } else {
      val firstArg = args.head
      if (firstArg.startsWith("--")) {
        val maybeRunner = CustomRunner.runnerByName(firstArg.substring(2))
        maybeRunner match {
          case Some(runner) => {
            val argsOfRunner = args.splitAt(1)._2
            executeRunner(runner, argsOfRunner)
          }
          case None =>
            println(AnsiColor.red(s"Invalid runner ${firstArg}"))
            printUsages
        }
      } else {
        executeRunner(DefaultCustomRunner, args)
      }
    }
  }

  private def printUsages = {
    println("Valid Options are: ")
    CustomRunner.customRunners.foreach((runner) => {
      print("\t  dw ")
      runner.usage()
    })
  }

  private def executeRunner(runner: CustomRunner, argsOfRunner: Array[String]) = {
    val config = runner.parseArgs(argsOfRunner)
    config match {
      case Left(config) => runner.run(config)
      case Right(errorMessage) => {
        println(AnsiColor.red(errorMessage))
        println("dw ")
        runner.usage()
      }
    }
  }
}
