package org.mule.weave.v2.runtime.core.operator.math

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.NumberType
import org.mule.weave.v2.model.values.NumberValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.location.WeaveLocation

class NumberMinusOperator(override val location: WeaveLocation) extends UnaryFunctionValue {

  override val R = NumberType

  override def doExecute(rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    NumberValue(rightValue.evaluate.unary_-(), this)
  }
}
