package org.mule.weave.v2.runtime.core.operator.equality

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.AnyType
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.runtime.core.operator.logical.NotOperator
import org.mule.weave.v2.parser.location.WeaveLocation

class NotEqOperator(override val location: WeaveLocation) extends BinaryFunctionValue {
  override val L = AnyType

  override val R = AnyType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    NotOperator.doExecute(EqOperator.doExecute(leftValue, rightValue))
  }
}
