package org.mule.weave.v2.runtime.core.functions.types

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.BooleanType
import org.mule.weave.v2.model.types.NumberType
import org.mule.weave.v2.model.types.StringType
import org.mule.weave.v2.model.types.TypeType
import org.mule.weave.v2.model.values.BooleanValue
import org.mule.weave.v2.model.values.NumberValue
import org.mule.weave.v2.model.values.StringValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.runtime.core.functions.types.exceptions.NonLiteralTypeException

object LiteralTypeValueFunction extends UnaryFunctionValue {
  override val R = TypeType

  override def doExecute(v: R.V)(implicit executionContext: EvaluationContext): Value[_] = {
    v.evaluate.baseType match {
      case stringType: StringType   => stringType.value.map(StringValue(_)).getOrElse(throw new NonLiteralTypeException(location(), stringType.name))
      case booleanType: BooleanType => booleanType.value.map(BooleanValue(_)).getOrElse(throw new NonLiteralTypeException(location(), booleanType.name))
      case numberType: NumberType   => numberType.value.map(NumberValue(_)).getOrElse(throw new NonLiteralTypeException(location(), numberType.name))
      case t                        => throw new NonLiteralTypeException(location(), t.name)
    }
  }
}
