package org.mule.weave.v2.runtime.core.functions.stringops

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.capabilities.UnknownLocationCapable
import org.mule.weave.v2.model.types.StringType
import org.mule.weave.v2.model.values.BooleanValue
import org.mule.weave.v2.model.values.Value

object StringEndsWithFunctionValue extends BinaryFunctionValue {

  override val L = StringType

  override val R = StringType

  override def doExecute(l: L.V, r: R.V)(implicit ctx: EvaluationContext): Value[_] = {

    BooleanValue(l.evaluate.toString.endsWith(r.evaluate.toString), UnknownLocationCapable)
  }

}

object EndsWithFunctionValue {
  val value = Seq(StringEndsWithFunctionValue)
}