package org.mule.weave.v2.runtime.core.functions.runtime

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.StringType
import org.mule.weave.v2.model.values.BooleanValue
import org.mule.weave.v2.model.values.Value

object EvaluateCompatibilityFlagFunctionValue extends UnaryFunctionValue {
  override val R: StringType = StringType

  override protected def doExecute(v: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val compatibilityFlag = v.evaluate.toString
    val value = ctx.serviceManager.settingsService.evaluateCompatibilityFlag(compatibilityFlag, location())
    BooleanValue(value)
  }
}
