package org.mule.weave.v2.runtime.core.functions.collections

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.KeyValuePair
import org.mule.weave.v2.model.types.ArrayType
import org.mule.weave.v2.model.types.ObjectType
import org.mule.weave.v2.model.values._
object ObjectRemoveFunctionValue extends BinaryFunctionValue {
  override val L = ObjectType

  override val R = ObjectType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val rhsObject = rightValue.materialize.evaluate
    val filterNot: Iterator[KeyValuePair] = leftValue.evaluate.toIterator().filterNot((v: KeyValuePair) => {
      //TODO this can be improved by searching by key
      rhsObject.toIterator().exists((v1: KeyValuePair) => {
        v1.isSimilarTo(v)
      })
    })
    ObjectValue(filterNot, this)
  }

}

object ArrayRemoveFunctionValue extends BinaryFunctionValue {
  override val L = ArrayType

  override val R = ArrayType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val rhsArray = rightValue.materialize
    val subtracted = leftValue.evaluate.toIterator().filterNot((v: Value[_]) => {
      rhsArray.evaluate(ctx).toIterator().exists((v1: Value[_]) => {
        v1.isSimilarTo(v)
      })
    })
    ArrayValue(subtracted, this)
  }

}
