package org.mule.weave.v2.runtime.core.functions.collections

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.AnyType
import org.mule.weave.v2.model.types.ArrayType
import org.mule.weave.v2.model.types.RegexType
import org.mule.weave.v2.model.types.StringType
import org.mule.weave.v2.model.values._

import java.util.regex.Matcher
object ArrayContainsFunctionValue extends BinaryFunctionValue {
  val L = ArrayType
  val R = AnyType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val mrhs = rightValue.materialize
    BooleanValue(leftValue.evaluate.toIterator().exists(_.equals(mrhs)))
  }
}

object StringStringContainsFunctionValue extends BinaryFunctionValue {
  val L = StringType
  val R = StringType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val value: String = leftValue.evaluate.toString
    BooleanValue(value.contains(rightValue.evaluate))
  }
}

object StringRegexContainsFunctionValue extends BinaryFunctionValue {
  val L = StringType
  val R = RegexType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val pattern = rightValue.evaluate.pattern
    val matcher: Matcher = ctx.serviceManager.patternService.matcher(pattern, leftValue.evaluate, this)
    if (matcher.find()) {
      BooleanValue.TRUE_BOOL
    } else {
      BooleanValue.FALSE_BOOL
    }
  }
}

