package org.mule.weave.v2.runtime.core.functions

import org.mule.weave.v2.model.values.FunctionValue
import org.mule.weave.v2.model.values.NativeFunctionUtils.putInto
import org.mule.weave.v2.runtime.core.functions.binary.ReadLinesFunctionValue
import org.mule.weave.v2.runtime.core.functions.binary.WriteLinesFunctionValue

import scala.collection.mutable

/**
  * Registers all the functions for the dw::core::Binaries module
  */
object BinariesNativeFunctions {

  def registerFunction(catalog: mutable.Map[String, FunctionValue]): Unit = {
    {
      putInto(ReadLinesFunctionValue, catalog)
      putInto(WriteLinesFunctionValue, catalog)
    }
  }

}
