package org.mule.weave.v2.interpreted.node.structure.schema

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.node.ValueNode
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.model.values.SchemaValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.utils.SchemaNodeOrigin

case class SchemaNode(properties: Seq[SchemaPropertyNode], annotationSchema: SchemaNodeOrigin) extends ValueNode[Schema] with Product {

  override def productElement(n: Int): Any = properties.apply(n)

  override def productArity: Int = properties.length

  override def doExecute(implicit ctx: ExecutionContext): Value[Schema] = {
    val newProperties = properties
      .filter((p) => {
        p.condition.isEmpty || p.condition.get.execute.evaluate
      })
      .map((p) => {
        p.execute.evaluate
      })
    SchemaValue(Schema(newProperties), this)
  }

}
