package org.mule.weave.v2.interpreted.node.structure

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.node.ValueNode
import org.mule.weave.v2.model.structure.NameSeq
import org.mule.weave.v2.model.types.AttributesType
import org.mule.weave.v2.model.types.ObjectType
import org.mule.weave.v2.model.values.AttributesValue
import org.mule.weave.v2.model.values.NameValuePairValue
import org.mule.weave.v2.model.values.Value

class AttributesNode(val attrs: Seq[ValueNode[_]]) extends ValueNode[NameSeq] {
  override def doExecute(implicit executionContext: ExecutionContext): Value[NameSeq] = {
    val mapped = attrs.filter((node) => {
      node match {
        case ccn: ConditionalCapableNode => ccn.condition
        case _                           => true
      }
    }).flatMap((v: ValueNode[_]) => {
      v.execute match {
        case kv: NameValuePairValue => Seq(kv.evaluate)
        case v: Value[_] if AttributesType.accepts(v) => {
          v.evaluate.asInstanceOf[NameSeq].toStream()
        }
        case v: Value[_] if ObjectType.accepts(v) => {
          AttributesType.coerce(v).evaluate.toStream()
        }
        case _ => Seq()
      }
    })

    AttributesValue(mapped, this)
  }

  override def productElement(n: Int): Any = attrs.apply(n)

  override def productArity: Int = attrs.length
}

object AttributesNode {
  def apply(attrs: Seq[ValueNode[_]]) = new AttributesNode(attrs)
}