package org.mule.weave.v2.interpreted.node

import org.mule.weave.v2.core.exception.InvalidSelectionException
import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.model.values.Value

class NullUnSafeNode(selector: ValueNode[_]) extends ValueNode[Any] with Product1[ValueNode[_]] {

  override def _1: ValueNode[_] = selector

  override def doExecute(implicit executionContext: ExecutionContext): Value[_] = {
    try {
      selector.execute
    } catch {
      case e: InvalidSelectionException => throw e.reason
    }
  }

}

object NullUnSafeNode {
  def apply(selector: ValueNode[_]): NullUnSafeNode = new NullUnSafeNode(selector)
}
