package org.mule.weave.v2.interpreted.node

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.node.executors.BinaryExecutor
import org.mule.weave.v2.model.values.NullValue
import org.mule.weave.v2.model.values.Value

class ChainedBinaryOpNode(val operations: Array[BinaryExecutor], val nodes: Array[ValueNode[Any]]) extends ValueNode[Any] {

  override def productElement(n: Int): Any = {
    nodes.apply(n)
  }

  override def productArity: Int = nodes.length

  override protected def doExecute(implicit ctx: ExecutionContext): Value[Any] = {
    var i = 0
    var leftValue: Value[_] = NullValue
    var rightValue: Value[_] = NullValue
    if (ctx.notificationManager().nonEmpty) {
      while (i < nodes.length) {
        if (i == 0) {
          leftValue = nodes(0).execute
        } else {
          ctx.notificationManager().preValueNodeExecution(nodes(i - 1))
          rightValue = nodes(i).execute
          leftValue = operations(i - 1).executeBinary(leftValue, rightValue)
          ctx.notificationManager().postValueNodeExecution(nodes(i - 1), leftValue)
        }
        i = i + 1
      }
    } else {
      while (i < nodes.length) {
        if (i == 0) {
          leftValue = nodes(0).execute
        } else {
          rightValue = nodes(i).execute
          leftValue = operations(i - 1).executeBinary(leftValue, rightValue)
        }
        i = i + 1
      }
    }
    leftValue
  }
}
