package org.mule.weave.v2.interpreted.listener

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.node.ValueNode
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.runtime.ExecutableWeave

/**
  * This listener is going to be called after and before each node in the tree.
  *
  */
trait WeaveExecutionListener {
  /**
    * When the execution started
    */
  def onExecutionStarted(executableWeave: ExecutableWeave[_ <: AstNode])(implicit ctx: EvaluationContext): Unit = {}

  /**
    * Before the node gets executed
    *
    * @param node The node to be executed
    * @param ctx  the execution context
    */
  def preExecution(node: ValueNode[_])(implicit ctx: ExecutionContext): Unit

  /**
    * After the node was successfully executed
    *
    * @param node   The node
    * @param result The result of that node
    * @param ctx    the execution context
    */
  def postExecution(node: ValueNode[_], result: Value[_])(implicit ctx: ExecutionContext): Unit

  /**
    * After the node failed to execute
    *
    * @param node The node
    * @param e    The exception
    * @param ctx  the execution context
    */
  def postExecution(node: ValueNode[_], e: Exception)(implicit ctx: ExecutionContext): Unit

  /**
    * When the execution ended
    */
  def onExecutionEnded(executableWeave: ExecutableWeave[_ <: AstNode])(implicit ctx: EvaluationContext): Unit = {}
}
