package org.mule.weave.v2.interpreted.debugger.server

import org.mule.weave.v2.debugger.commands.ClientCommand
import org.mule.weave.v2.debugger.event.RemoteServerMessage

trait ServerProtocol {

  def isStarted(): Boolean

  def addClientConnectionListener(clientConnectionListener: ClientConnectionListener)

  def send(event: RemoteServerMessage): Unit

  def start(daemon: Boolean = true): Unit

  def disconnect()

  def addCommandHandler[T <: ClientCommand[_, _]](clazz: Class[T], handler: CommandHandler[T])
}

trait CommandHandler[T <: ClientCommand[_, _]] {

  type CommandType = T

  def handle(command: CommandType)
}