package org.mule.weave.v2.interpreted.debugger.server

import org.mule.weave.v2.debugger.DebuggerLocation
import org.mule.weave.v2.debugger.DebuggerPosition
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.location.Location
import org.mule.weave.v2.parser.location.Position
import org.mule.weave.v2.parser.location.UnknownLocation
import org.mule.weave.v2.parser.location.WeaveLocation

object DebuggerConverters {

  def toDebuggerPosition(resourceName: NameIdentifier, startPosition: Position): DebuggerPosition = {
    DebuggerPosition(startPosition.index, startPosition.line, startPosition.column, resourceName.name)
  }

  def toDebuggerLocation(location: WeaveLocation): DebuggerLocation = {
    DebuggerLocation(toDebuggerPosition(location.resourceName, location.startPosition), toDebuggerPosition(location.resourceName, location.endPosition))
  }

  def toDebuggerLocation(location: Location): DebuggerLocation = {
    location match {
      case weaveLocation: WeaveLocation => {
        toDebuggerLocation(weaveLocation)
      }
      case _ =>
        unknownLocation()
    }

  }

  def unknownLocation(): DebuggerLocation = {
    toDebuggerLocation(UnknownLocation)
  }
}
