/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.runtime;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier$;
import org.mule.weave.v2.runtime.InputType;
import org.mule.weave.v2.runtime.ModuleComponentsFactory;
import org.mule.weave.v2.runtime.ScriptingEngineSetupException;
import org.mule.weave.v2.sdk.NameIdentifierHelper$;
import org.mule.weave.v2.sdk.ParsingContextFactory$;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResource$;
import org.mule.weave.v2.sdk.WeaveResourceFactory$;
import org.mule.weave.v2.ts.WeaveType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005=g\u0001B\u0015+\u0001UB\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\u0006\u0003\u0002!\tA\u0011\u0005\b\u000b\u0002\u0001\r\u0011\"\u0003G\u0011\u001d\u0001\u0006\u00011A\u0005\nECaa\u0016\u0001!B\u00139\u0005b\u0002-\u0001\u0001\u0004%I!\u0017\u0005\bM\u0002\u0001\r\u0011\"\u0003h\u0011\u0019I\u0007\u0001)Q\u00055\"9!\u000e\u0001a\u0001\n\u0013Y\u0007bB<\u0001\u0001\u0004%I\u0001\u001f\u0005\u0007u\u0002\u0001\u000b\u0015\u00027\t\u000fm\u0004\u0001\u0019!C\u0005y\"I\u0011\u0011\u0002\u0001A\u0002\u0013%\u00111\u0002\u0005\b\u0003\u001f\u0001\u0001\u0015)\u0003~\u0011!\t\t\u0002\u0001a\u0001\n\u0013I\u0006\"CA\n\u0001\u0001\u0007I\u0011BA\u000b\u0011\u001d\tI\u0002\u0001Q!\niC\u0011\"a\u0007\u0001\u0001\u0004%I!!\b\t\u0013\u00055\u0002\u00011A\u0005\n\u0005=\u0002\u0002CA\u001a\u0001\u0001\u0006K!a\b\t\u0013\u0005U\u0002\u00011A\u0005\n\u0005]\u0002\"CA!\u0001\u0001\u0007I\u0011BA\"\u0011!\t9\u0005\u0001Q!\n\u0005e\u0002bBA%\u0001\u0011\u0005\u00111\n\u0005\b\u0003#\u0002A\u0011AA*\u0011\u001d\tI\u0006\u0001C\u0001\u00037Bq!!\u001d\u0001\t\u0003\t\u0019\bC\u0004\u0002\u0006\u0002!\t!a\"\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002\u000e\"9\u0011\u0011\u0013\u0001\u0005\u0002\u0005M\u0005bBAI\u0001\u0011\u0005\u00111\u0014\u0005\b\u0003?\u0003A\u0011AAQ\u0011\u001d\t9\u000b\u0001C\u0001\u0003SCq!a,\u0001\t\u0003\t\t\fC\u0004\u00028\u0002!\t!!/\t\u000f\u0005m\u0006\u0001\"\u0001\u0002>\"9\u0011q\u0018\u0001\u0005\u0002\u0005\u0005\u0007bBAb\u0001\u0011\u0005\u0011Q\u0019\u0005\b\u0003\u000f\u0004A\u0011AAe\u0011\u001d\tY\r\u0001C\u0001\u0003\u001b\u0014\u0011cQ8na&d\u0017\r^5p]\u000e{gNZ5h\u0015\tYC&A\u0004sk:$\u0018.\\3\u000b\u00055r\u0013A\u0001<3\u0015\ty\u0003'A\u0003xK\u00064XM\u0003\u00022e\u0005!Q.\u001e7f\u0015\u0005\u0019\u0014aA8sO\u000e\u00011C\u0001\u00017!\t9$(D\u00019\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e9\u0005\u0019\te.\u001f*fM\u0006\t2m\\7q_:,g\u000e^:GC\u000e$xN]=\u0011\u0005yzT\"\u0001\u0016\n\u0005\u0001S#aF'pIVdWmQ8na>tWM\u001c;t\r\u0006\u001cGo\u001c:z\u0003\u0019a\u0014N\\5u}Q\u00111\t\u0012\t\u0003}\u0001AQ\u0001\u0010\u0002A\u0002u\n\u0011b\u0018:fg>,(oY3\u0016\u0003\u001d\u00032a\u000e%K\u0013\tI\u0005H\u0001\u0004PaRLwN\u001c\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001b2\n1a\u001d3l\u0013\tyEJA\u0007XK\u00064XMU3t_V\u00148-Z\u0001\u000e?J,7o\\;sG\u0016|F%Z9\u0015\u0005I+\u0006CA\u001cT\u0013\t!\u0006H\u0001\u0003V]&$\bb\u0002,\u0005\u0003\u0003\u0005\raR\u0001\u0004q\u0012\n\u0014AC0sKN|WO]2fA\u00059ql]2sSB$X#\u0001.\u0011\u0007]B5\f\u0005\u0002]G:\u0011Q,\u0019\t\u0003=bj\u0011a\u0018\u0006\u0003AR\na\u0001\u0010:p_Rt\u0014B\u000129\u0003\u0019\u0001&/\u001a3fM&\u0011A-\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\tD\u0014aC0tGJL\u0007\u000f^0%KF$\"A\u00155\t\u000fY;\u0011\u0011!a\u00015\u0006Aql]2sSB$\b%A\u0006`S\u0012,g\u000e^5gS\u0016\u0014X#\u00017\u0011\u0007]BU\u000e\u0005\u0002ok6\tqN\u0003\u0002qc\u0006Ia/\u0019:jC\ndWm\u001d\u0006\u0003eN\f1!Y:u\u0015\t!H&\u0001\u0004qCJ\u001cXM]\u0005\u0003m>\u0014aBT1nK&#WM\u001c;jM&,'/A\b`S\u0012,g\u000e^5gS\u0016\u0014x\fJ3r)\t\u0011\u0016\u0010C\u0004W\u0015\u0005\u0005\t\u0019\u00017\u0002\u0019}KG-\u001a8uS\u001aLWM\u001d\u0011\u0002\u000f}Kg\u000e];ugV\tQ\u0010E\u00028\u0011z\u0004BaN@\u0002\u0004%\u0019\u0011\u0011\u0001\u001d\u0003\u000b\u0005\u0013(/Y=\u0011\u0007y\n)!C\u0002\u0002\b)\u0012\u0011\"\u00138qkR$\u0016\u0010]3\u0002\u0017}Kg\u000e];ug~#S-\u001d\u000b\u0004%\u00065\u0001b\u0002,\u000e\u0003\u0003\u0005\r!`\u0001\t?&t\u0007/\u001e;tA\u00051r\fZ3gCVdGoT;uaV$X*[7f)f\u0004X-\u0001\u000e`I\u00164\u0017-\u001e7u\u001fV$\b/\u001e;NS6,G+\u001f9f?\u0012*\u0017\u000fF\u0002S\u0003/AqA\u0016\t\u0002\u0002\u0003\u0007!,A\f`I\u00164\u0017-\u001e7u\u001fV$\b/\u001e;NS6,G+\u001f9fA\u0005Ar\fZ3gCVdGo\u0016:ji\u0016\u0014\bK]8qKJ$\u0018.Z:\u0016\u0005\u0005}\u0001\u0003B\u001cI\u0003C\u0001b\u0001XA\u00127\u0006\u001d\u0012bAA\u0013K\n\u0019Q*\u00199\u0011\u0007]\nI#C\u0002\u0002,a\u00121!\u00118z\u0003qyF-\u001a4bk2$xK]5uKJ\u0004&o\u001c9feRLWm]0%KF$2AUA\u0019\u0011!16#!AA\u0002\u0005}\u0011!G0eK\u001a\fW\u000f\u001c;Xe&$XM\u001d)s_B,'\u000f^5fg\u0002\n\u0001bX7bqRKW.Z\u000b\u0003\u0003s\u0001Ba\u000e%\u0002<A\u0019q'!\u0010\n\u0007\u0005}\u0002H\u0001\u0003M_:<\u0017\u0001D0nCb$\u0016.\\3`I\u0015\fHc\u0001*\u0002F!AaKFA\u0001\u0002\u0004\tI$A\u0005`[\u0006DH+[7fA\u0005aq/\u001b;i%\u0016\u001cx.\u001e:dKR\u00191)!\u0014\t\r\u0005=\u0003\u00041\u0001K\u0003!\u0011Xm]8ve\u000e,\u0017AC<ji\"\u001c6M]5qiR\u00191)!\u0016\t\r\u0005]\u0013\u00041\u0001\\\u0003\u0019\u00198M]5qi\u00069q/\u001b;i+JdGcA\"\u0002^!9\u0011q\f\u000eA\u0002\u0005\u0005\u0014aA;sYB!\u00111MA7\u001b\t\t)G\u0003\u0003\u0002h\u0005%\u0014a\u00018fi*\u0011\u00111N\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002p\u0005\u0015$aA+S\u0019\u0006Aq/\u001b;i\r&dW\rF\u0002D\u0003kBq!a\u001e\u001c\u0001\u0004\tI(\u0001\u0003gS2,\u0007\u0003BA>\u0003\u0003k!!! \u000b\t\u0005}\u0014\u0011N\u0001\u0003S>LA!a!\u0002~\t!a)\u001b7f\u0003I9\u0018\u000e\u001e5OC6,\u0017\nZ3oi&4\u0017.\u001a:\u0015\u0007\r\u000bI\t\u0003\u0004\u0002\fr\u0001\r!\\\u0001\u000f]\u0006lW-\u00133f]RLg-[3s)\r\u0019\u0015q\u0012\u0005\u0007\u0003\u0017k\u0002\u0019A.\u0002\u0015]LG\u000f[%oaV$8\u000fF\u0002D\u0003+Cq!a&\u001f\u0001\u0004\tI*\u0001\bj[Bd\u0017nY5u\u0013:\u0004X\u000f^:\u0011\u0007]z8\fF\u0002D\u0003;Ca!a& \u0001\u0004q\u0018!F<ji\"$UMZ1vYR|U\u000f\u001e9viRK\b/\u001a\u000b\u0004\u0007\u0006\r\u0006BBASA\u0001\u00071,\u0001\u0005nS6,G+\u001f9f\u0003m9\u0018\u000e\u001e5EK\u001a\fW\u000f\u001c;Xe&$XM\u001d)s_B,'\u000f^5fgR\u00191)a+\t\u000f\u00055\u0016\u00051\u0001\u0002\"\u0005)\u0001O]8qg\u0006Yq/\u001b;i\u001b\u0006DH+[7f)\r\u0019\u00151\u0017\u0005\b\u0003k\u0013\u0003\u0019AA\u001e\u0003\u001di\u0017\r\u001f+j[\u0016\f1bZ3u%\u0016\u001cx.\u001e:dKR\t!*A\u0007hKRLE-\u001a8uS\u001aLWM\u001d\u000b\u0002[\u0006Iq-\u001a;J]B,Ho\u001d\u000b\u0002}\u0006Ar-\u001a;EK\u001a\fW\u000f\u001c;PkR\u0004X\u000f^'j[\u0016$\u0016\u0010]3\u0015\u0003m\u000b!dZ3u\t\u00164\u0017-\u001e7u/JLG/\u001a:Qe>\u0004XM\u001d;jKN$\"!!\t\u0002\u0015\u001d,G/T1y)&lW\r\u0006\u0002\u0002<\u0001")
public class CompilationConfig {
    private final ModuleComponentsFactory componentsFactory;
    private Option<WeaveResource> _resource;
    private Option<String> _script;
    private Option<NameIdentifier> _identifier;
    private Option<InputType[]> _inputs;
    private Option<String> _defaultOutputMimeType;
    private Option<Map<String, Object>> _defaultWriterProperties;
    private Option<Object> _maxTime;

    private Option<WeaveResource> _resource() {
        return this._resource;
    }

    private void _resource_$eq(Option<WeaveResource> x$1) {
        this._resource = x$1;
    }

    private Option<String> _script() {
        return this._script;
    }

    private void _script_$eq(Option<String> x$1) {
        this._script = x$1;
    }

    private Option<NameIdentifier> _identifier() {
        return this._identifier;
    }

    private void _identifier_$eq(Option<NameIdentifier> x$1) {
        this._identifier = x$1;
    }

    private Option<InputType[]> _inputs() {
        return this._inputs;
    }

    private void _inputs_$eq(Option<InputType[]> x$1) {
        this._inputs = x$1;
    }

    private Option<String> _defaultOutputMimeType() {
        return this._defaultOutputMimeType;
    }

    private void _defaultOutputMimeType_$eq(Option<String> x$1) {
        this._defaultOutputMimeType = x$1;
    }

    private Option<Map<String, Object>> _defaultWriterProperties() {
        return this._defaultWriterProperties;
    }

    private void _defaultWriterProperties_$eq(Option<Map<String, Object>> x$1) {
        this._defaultWriterProperties = x$1;
    }

    private Option<Object> _maxTime() {
        return this._maxTime;
    }

    private void _maxTime_$eq(Option<Object> x$1) {
        this._maxTime = x$1;
    }

    public CompilationConfig withResource(WeaveResource resource) {
        this._resource_$eq((Option<WeaveResource>)new Some((Object)resource));
        return this;
    }

    public CompilationConfig withScript(String script) {
        this._script_$eq((Option<String>)new Some((Object)script));
        return this;
    }

    public CompilationConfig withUrl(URL url) {
        this._resource_$eq((Option<WeaveResource>)new Some((Object)WeaveResourceFactory$.MODULE$.fromUrl(url)));
        this._identifier_$eq((Option<NameIdentifier>)new Some((Object)NameIdentifier$.MODULE$.fromPath(url.getPath())));
        return this;
    }

    public CompilationConfig withFile(File file) {
        this._resource_$eq((Option<WeaveResource>)new Some((Object)WeaveResourceFactory$.MODULE$.fromFile(file)));
        this._identifier_$eq((Option<NameIdentifier>)new Some((Object)ParsingContextFactory$.MODULE$.nameIdentifier(file, ParsingContextFactory$.MODULE$.nameIdentifier$default$2())));
        return this;
    }

    public CompilationConfig withNameIdentifier(NameIdentifier nameIdentifier) {
        this._identifier_$eq((Option<NameIdentifier>)new Some((Object)nameIdentifier));
        return this;
    }

    public CompilationConfig withNameIdentifier(String nameIdentifier) {
        this._identifier_$eq((Option<NameIdentifier>)new Some((Object)new NameIdentifier(nameIdentifier, NameIdentifier$.MODULE$.apply$default$2())));
        return this;
    }

    public CompilationConfig withInputs(String[] implicitInputs) {
        this._inputs_$eq((Option<InputType[]>)new Some(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])implicitInputs)).map((Function1 & Serializable & scala.Serializable)x$1 -> new InputType((String)x$1, (Option<WeaveType>)None$.MODULE$), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InputType.class)))));
        return this;
    }

    public CompilationConfig withInputs(InputType[] implicitInputs) {
        this._inputs_$eq((Option<InputType[]>)new Some((Object)implicitInputs));
        return this;
    }

    public CompilationConfig withDefaultOutputType(String mimeType) {
        this._defaultOutputMimeType_$eq((Option<String>)new Some((Object)mimeType));
        return this;
    }

    public CompilationConfig withDefaultWriterProperties(Map<String, Object> props) {
        this._defaultWriterProperties_$eq((Option<Map<String, Object>>)new Some(props));
        return this;
    }

    public CompilationConfig withMaxTime(long maxTime) {
        this._maxTime_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)maxTime)));
        return this;
    }

    public WeaveResource getResource() {
        WeaveResource weaveResource;
        if (this._resource().isDefined()) {
            weaveResource = (WeaveResource)this._resource().get();
        } else if (this._script().isDefined() && this._identifier().isDefined()) {
            weaveResource = WeaveResource$.MODULE$.apply(NameIdentifierHelper$.MODULE$.toWeaveFilePath((NameIdentifier)this._identifier().get()), (String)this._script().get());
        } else if (this._script().isDefined()) {
            weaveResource = WeaveResource$.MODULE$.anonymous((String)this._script().get());
        } else if (this._identifier().isDefined()) {
            weaveResource = (WeaveResource)this.componentsFactory.createComponents().resourceResolver().resolve((NameIdentifier)this._identifier().get()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new ScriptingEngineSetupException(new StringBuilder(31).append("Unable to resolve resource for ").append(((NameIdentifier)this._identifier().get()).name()).toString());
            });
        } else {
            throw new ScriptingEngineSetupException("Unable to resolve resource");
        }
        return weaveResource;
    }

    public NameIdentifier getIdentifier() {
        return (NameIdentifier)this._identifier().getOrElse((Function0 & Serializable & scala.Serializable)() -> NameIdentifier$.MODULE$.anonymous());
    }

    public InputType[] getInputs() {
        return (InputType[])this._inputs().getOrElse((Function0 & Serializable & scala.Serializable)() -> (InputType[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(InputType.class)));
    }

    public String getDefaultOutputMimeType() {
        return (String)this._defaultOutputMimeType().getOrElse((Function0 & Serializable & scala.Serializable)() -> "application/dw");
    }

    public Map<String, Object> getDefaultWriterProperties() {
        return (Map)this._defaultWriterProperties().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
    }

    public long getMaxTime() {
        return BoxesRunTime.unboxToLong((Object)this._maxTime().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
    }

    public CompilationConfig(ModuleComponentsFactory componentsFactory) {
        this.componentsFactory = componentsFactory;
        this._resource = None$.MODULE$;
        this._script = None$.MODULE$;
        this._identifier = None$.MODULE$;
        this._inputs = None$.MODULE$;
        this._defaultOutputMimeType = None$.MODULE$;
        this._defaultWriterProperties = None$.MODULE$;
        this._maxTime = None$.MODULE$;
    }
}

