package org.mule.weave.v2.module.pojo.reader

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.KeyValuePair
import org.mule.weave.v2.model.values.KeyValuePairValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.module.commons.java.value.JavaLocation
import org.mule.weave.v2.parser.location.Location

class JavaKeyValuePairValue(val v: (String, Value[_]), loc: () => String) extends KeyValuePairValue {
  lazy val kv = KeyValuePair(new JavaStringKeyValue(v._1, loc), v._2)
  override def evaluate(implicit ctx: EvaluationContext) = kv
  override def location(): Location = new JavaLocation(loc())
}
