package org.mule.weave.v2.module.commons.java.writer.exception

import org.mule.weave.v2.core.exception.WriterException
import org.mule.weave.v2.parser.location.Location

class CanNotConvertValueException(val location: Location, val value: Any, val targetClass: String) extends WriterException {
  override def message: String = {
    val name = if (value != null) value.getClass.getCanonicalName else "null"
    "Unable to convert '" + value + "' with class '" + name + "' to class '" + targetClass + "'"
  }
}

