package org.mule.weave.v2.module.commons.java.writer.entry

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.QualifiedName
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.module.commons.java.writer.ClassSchemaNode
import org.mule.weave.v2.module.commons.java.writer.JavaAdapter
import org.mule.weave.v2.module.commons.java.writer.converter.BaseJavaDataConverter
import org.mule.weave.v2.module.commons.java.writer.exception.CanNotConvertValueException
import org.mule.weave.v2.parser.location.LocationCapable

trait WriterEntry {

  implicit val converter: BaseJavaDataConverter

  def putValue(value: Any, valueSchema: Option[Schema])(implicit ctx: EvaluationContext) {
    if (value == null) {
      val theNullValueAdapted = adapt(value, valueSchema)
      theNullValueAdapted match {
        case Some(newValue) => write(newValue)
        case None           => write(value)
      }
    } else if (entryType().isAssignableFrom(value.getClass)) {
      write(JavaAdapter.fromScalaToJava(value.asInstanceOf[Object]))
    } else {
      val adaptedValue: Option[Any] = adapt(value, valueSchema)
      if (adaptedValue.isDefined) {
        val adaptedObject: Object = adaptedValue.get.asInstanceOf[Object]
        write(adaptedObject)
      } else {
        throw new CanNotConvertValueException(location().location(), value, entryType().getCanonicalName)
      }
    }
  }

  def schemaOption: Option[Schema] = None

  /**
    * Returns the expected of the type needed on the put value
    */
  def entryType(): Class[_] = {
    classOf[Object]
  }

  def contentTypeSchema(): Option[ClassSchemaNode] = None

  def adapt(value: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[Any] = {
    converter.to(value, schema, entryType())
  }

  def location(): LocationCapable

  def write(value: Any): Unit

  def genericType(index: Int): Option[Class[_]] = None

  /**
    * Returns the actual value
    */
  def resolveEntryValue(): Any
}

trait PropertyAwareEntry {

  def createPropertyEntry(location: LocationCapable, qname: QualifiedName, schema: Option[Schema]): WriterEntry
}
