package org.mule.weave.v2.module.commons.java.writer.entry

import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.module.commons.java.writer.ClassSchemaNode
import org.mule.weave.v2.module.commons.java.writer.ClassTypeWithRestriction
import org.mule.weave.v2.module.commons.java.writer.JavaAdapter
import org.mule.weave.v2.module.commons.java.writer.converter.BaseJavaDataConverter
import org.mule.weave.v2.parser.location.LocationCapable

import java.util

class ListEntry(override val location: LocationCapable, container: util.Collection[Any], sval: Option[Schema], component: ClassTypeWithRestriction)(implicit val converter: BaseJavaDataConverter) extends WriterEntry {
  def write(value: Any) {
    container.add(JavaAdapter.fromScalaToJava(value))
  }

  override def entryType(): Class[_] = component.classValue.getOrElse(classOf[Object])

  override def contentTypeSchema(): Option[ClassSchemaNode] = component.constrainClassSchema

  override def resolveEntryValue(): Any = container
}
