package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.model.values.BinaryValue

import java.io.InputStream

class StringDataConverter extends DataConverter[String] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[String] = {
    source match {
      case inputStream: InputStream => {
        try {
          Some(new String(BinaryValue.getBytesFromInputStream(inputStream, ctx.serviceManager.memoryService)))
        } finally {
          inputStream.close()
        }
      }
      case bytes: Array[Byte] => Some(new String(bytes))
      case _                  => Some(source.toString)
    }
  }
}
