package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.module.commons.java.writer.converter.BaseJavaDataConverter.DateDataConverter$

import java.sql.Time
import java.util

class SqlTimeDataConverter extends DataConverter[Time] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[Time] = {
    source match {
      case time: Time => Some(time)
      case _ => {
        val maybeDate: Option[util.Date] = DateDataConverter$.convert(source, schema)
        if (maybeDate.isDefined) {
          Option(new Time(maybeDate.get.getTime))
        } else {
          None
        }
      }
    }

  }
}
