package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.module.commons.java.writer.converter.BaseJavaDataConverter.DateDataConverter$

import java.sql.Date
import java.util

class SqlDateDataConverter extends DataConverter[Date] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[Date] = {
    source match {
      case date: Date => Some(date)
      case _ => {
        val maybeDate: Option[util.Date] = DateDataConverter$.convert(source, schema)
        if (maybeDate.isDefined) {
          Option(new Date(maybeDate.get.getTime))
        } else {
          None
        }
      }
    }

  }
}
