package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema

import java.util.OptionalDouble

class OptionalDoubleDataConverter extends DataConverter[OptionalDouble] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[OptionalDouble] = {
    //Makes sure that we are wrapping a java value
    if (source == null) {
      Some(OptionalDouble.empty())
    } else {
      val converter = new DoubleDataConverter()
      converter
        .convert(source, schema)
        .map((intValue) => OptionalDouble.of(intValue))
    }
  }
}
