package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.module.commons.java.writer.JavaAdapter

import java.util.Optional

class OptionalDataConverter extends DataConverter[Optional[_]] {

  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[Optional[_]] = {
    //Makes sure that we are wrapping a java value
    Some(Optional.ofNullable(JavaAdapter.fromScalaToJava(source)))
  }
}
