package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema

import java.util.concurrent.atomic.AtomicLong

class AtomicLongDataConverter extends DataConverter[AtomicLong] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[AtomicLong] = {
    val longConverter = new LongDataConverter
    longConverter.convert(source, schema).map(new AtomicLong(_))
  }
}
