package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema

import java.util.concurrent.atomic.AtomicInteger

class AtomicIntegerDataConverter extends DataConverter[AtomicInteger] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[AtomicInteger] = {
    val intConverter = new IntDataConverter
    intConverter.convert(source, schema).map(new AtomicInteger(_))
  }
}
