package org.mule.weave.v2.module.commons.java.reader

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.module.commons.java.value.JavaValueConverter
import org.mule.weave.v2.module.reader.NonConfigurableReader

trait BaseJavaReader extends NonConfigurableReader {

  val rootValue: Any

  var value: Value[_] = _

  def context: EvaluationContext

  def converter: JavaValueConverter

  def doRead(name: String): Value[_] = {
    if (value == null) {
      value = converter.convert(rootValue, () => name)(context)
    }
    value
  }

  override def getValue(): Value[_] = value
}
