package org.mule.weave.v2.module.commons.java

import org.mule.weave.v2.core.env.WeaveRuntime

trait JavaHeavyValueDiscover {
  /**
    * Check if the given instance should consider as heavy value.
    *
    * @param instance The instance to evaluate
    * @return true when it should consider as heavy value
    */
  def isHeavyValue(instance: Any): Boolean
}

class DefaultJavaHeavyValueDiscover extends JavaHeavyValueDiscover {

  override def isHeavyValue(instance: Any): Boolean = {
    false
  }
}

object JavaHeavyValue {

  private lazy val services: Seq[JavaHeavyValueDiscover] = WeaveRuntime
    .getServiceProvider()
    .serviceImplementations(classOf[JavaHeavyValueDiscover])

  /**
    * Check if the given instance should consider as heavy value.
    *
    * @param instance The instance to evaluate
    * @return true when it should consider as heavy value
    */
  def isHeavyValue(instance: Any): Boolean = {
    val it = services.iterator
    var isHeavy: Boolean = false
    while (!isHeavy && it.hasNext) {
      val strategy = it.next()
      isHeavy = strategy.isHeavyValue(instance)
    }
    isHeavy
  }
}