package org.mule.weave.v2.module.dwb.reader.indexed

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.model.values.StringValue
import org.mule.weave.v2.module.dwb.BinaryLocation
import org.mule.weave.v2.module.dwb.DwTokenHelper
import org.mule.weave.v2.parser.location.Location

class WeaveBinaryString(tokenIndex: Long, token: Array[Long], input: BinaryParserInput) extends StringValue {
  private val offset = DwTokenHelper.getOffset(token)
  private val length = DwTokenHelper.getValueLength(token)
  private var _schema: Option[Schema] = _
  private lazy val value: String = {
    input.sourceReader.readEncodedString(offset, length)
  }

  override def schema(implicit ctx: EvaluationContext): Option[Schema] = {
    if (_schema == null) {
      if (DwTokenHelper.hasSchemaProps(token)) {
        val schemaOffset = offset + length
        val schema = WeaveBinaryValue.readSchema(input, tokenIndex, schemaOffset)
        _schema = Some(schema)
      } else {
        _schema = None
      }
    }
    _schema
  }

  override def evaluate(implicit ctx: EvaluationContext): String = {
    value
  }

  override def location(): Location = new BinaryLocation(offset)
}

