package org.mule.weave.v2.module.dwb.reader.indexed

import java.time.LocalTime

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.LocalTimeValue
import org.mule.weave.v2.module.dwb.BinaryLocation
import org.mule.weave.v2.module.dwb.DwTokenHelper
import org.mule.weave.v2.parser.location.Location

class WeaveBinaryLocalTime(token: Array[Long], input: BinaryParserInput) extends LocalTimeValue {
  private lazy val offset: Long = DwTokenHelper.getOffset(token)
  private lazy val value: LocalTime = {
    val stream = input.dataInputStream
    input.seekableStream.seek(offset)
    val nanoOfDay = stream.readLong()
    LocalTime.ofNanoOfDay(nanoOfDay)
  }

  override def evaluate(implicit ctx: EvaluationContext): T = value
  override def location(): Location = new BinaryLocation(offset)
}
