package org.mule.weave.v2.module.dwb

import org.mule.weave.v2.core.io.DefaultHeapMemoryService
import org.mule.weave.v2.core.io.service.DefaultWorkingDirectoryService
import org.mule.weave.v2.dwb.api.WeaveDOMReader
import org.mule.weave.v2.dwb.api.WeaveStreamFactory
import org.mule.weave.v2.dwb.api.WeaveStreamWriter
import org.mule.weave.v2.model.service.DefaultSettingsService
import org.mule.weave.v2.module.dwb.reader.DefaultWeaveDOMReader
import org.mule.weave.v2.module.dwb.writer.DefaultWeaveStreamWriter
import org.mule.weave.v2.module.reader.DefaultAutoPersistedOutputStream

import java.io.InputStream
import java.io.OutputStream

class DefaultWeaveStreamFactory extends WeaveStreamFactory {

  override def createStreamWriter(os: OutputStream): WeaveStreamWriter = {
    new DefaultWeaveStreamWriter(os)
  }

  override def createPersistedOutputStream(): OutputStream = {
    new DefaultAutoPersistedOutputStream(new DefaultWorkingDirectoryService(), DefaultHeapMemoryService, DefaultSettingsService)
  }

  override def createDOMReader(is: InputStream): WeaveDOMReader = {
    new DefaultWeaveDOMReader(is)
  }
}
