package org.mule.weave.v2.module.dwb
import java.io.FilterInputStream
import java.io.InputStream

class CountingDataInputStream(in: InputStream) extends FilterInputStream(in) {

  private var count: Long = 0L

  /** Returns the number of bytes read. */
  def getCount: Long = count

  @inline
  private def incCount(readBytes: Int): Int = {
    if (readBytes != -1) {
      count += readBytes
    }
    readBytes
  }

  override def read(): Int = {
    val result: Int = in.read
    incCount(result)
  }

  override def read(b: Array[Byte]): Int = {
    read(b, 0, b.length)
  }

  override def read(b: Array[Byte], off: Int, len: Int): Int = {
    val result: Int = in.read(b, off, len)
    incCount(result)
  }

}
