package org.mule.weave.v2.debugger.commands

import org.mule.weave.v2.debugger.DebuggerValue
import org.mule.weave.v2.debugger.WeaveBreakpoint
import org.mule.weave.v2.debugger.WeaveExceptionBreakpoint

trait WeaveDebuggerCommandInterpreter {

  /**
    * Adds all the breakpoints
    * @param breakpoints the breakpoints to be added
    */
  def addBreakpoints(breakpoints: Array[WeaveBreakpoint]): Unit

  /**
    * Step into the calling function
    */
  def stepInto()

  /**
    * Step out the current execution to the callee
    */
  def stepOut()

  /**
    * Adds a new exception breakpoints
    * @param breakpoints The exceptions breakpoints
    */
  def addExceptionBreakpoint(breakpoints: Array[WeaveExceptionBreakpoint])

  /**
    * Adds a new exception breakpoints
    * @param breakpoint The exceptions breakpoints
    */
  def removeExceptionBreakpoint(breakpoint: WeaveExceptionBreakpoint)

  /**
    * Resumes the execution
    */
  def resume()

  /**
    * Remove the specified brekpoint
    * @param breakpoint the breakpoint to be removed
    */
  def removeBreakpoint(breakpoint: WeaveBreakpoint)

  /**
    * Resumes the execution until next step
    */
  def nextStep()

  /**
    * Initialize debugging session
    */
  def initSession()

  /**
    * Evaluates the script
    * @param script the script
    * @param frameId the frame where it needs to be executed
    * @return The result
    */
  def evaluateScript(script: String, frameId: Int): DebuggerValue

  /**
    * Clears all the breakpoints
    */
  def clearBreakpoints()

  /**
    * Adds a new breakpoint
    * @param breakpoint the new breakpoint
    */
  def addBreakpoint(breakpoint: WeaveBreakpoint)

}
