package org.mule.weave.v2.debugger.commands

import org.mule.weave.v2.debugger.WeaveBreakpoint
import org.mule.weave.v2.debugger.event.BreakpointRemovedEvent
import org.mule.weave.v2.debugger.event.DebuggerEvent

class RemoveBreakpointCommand(val breakpoint: WeaveBreakpoint) extends DebuggerCommand {
  override def call(debuggerContext: WeaveDebuggerCommandInterpreter): Option[DebuggerEvent] = {
    debuggerContext.removeBreakpoint(breakpoint)
    Some(BreakpointRemovedEvent(breakpoint))
  }
}
