package org.mule.weave.v2.debugger.commands

import org.mule.weave.v2.debugger.WeaveBreakpoint
import org.mule.weave.v2.debugger.event.BreakpointAddedEvent
import org.mule.weave.v2.debugger.event.DebuggerEvent

class AddBreakpointCommand(val breakpoint: WeaveBreakpoint) extends DebuggerCommand {
  override def call(debuggingSession: WeaveDebuggerCommandInterpreter): Option[DebuggerEvent] = {
    debuggingSession.addBreakpoint(breakpoint)
    Some(BreakpointAddedEvent(breakpoint))
  }
}
