/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.weave.compiler;

import com.mulesoft.weave.compiler.WeaveBinaryCompiler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import org.mule.weave.v2.compilation.SerializableAstNode;
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper$;
import org.mule.weave.v2.compilation.mapper.ResourceBasedSerializerContext;
import org.mule.weave.v2.compilation.mapper.SerializerContext;
import org.mule.weave.v2.compilation.serializer.SerializableAstNodeSerializer$;
import org.mule.weave.v2.core.io.FileHelper$;
import org.mule.weave.v2.interpreted.RuntimeModuleNodeCompiler;
import org.mule.weave.v2.interpreted.RuntimeModuleNodeCompiler$;
import org.mule.weave.v2.parser.DocumentParser;
import org.mule.weave.v2.parser.DocumentParser$;
import org.mule.weave.v2.parser.Message;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.DirectivesCapableNode;
import org.mule.weave.v2.parser.ast.module.ModuleNode;
import org.mule.weave.v2.parser.ast.structure.DocumentNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier$;
import org.mule.weave.v2.parser.location.WeaveLocation;
import org.mule.weave.v2.parser.module.ModuleLoaderProvider;
import org.mule.weave.v2.parser.phase.ModuleLoader$;
import org.mule.weave.v2.parser.phase.ModuleLoaderManager$;
import org.mule.weave.v2.parser.phase.ModuleParsingPhasesManager;
import org.mule.weave.v2.parser.phase.ModuleParsingPhasesManager$;
import org.mule.weave.v2.parser.phase.ParsingContext;
import org.mule.weave.v2.parser.phase.ParsingResult;
import org.mule.weave.v2.parser.phase.PhaseResult;
import org.mule.weave.v2.runtime.WeaveCompiler$;
import org.mule.weave.v2.sdk.ClassLoaderWeaveResourceResolver;
import org.mule.weave.v2.sdk.ClassLoaderWeaveResourceResolver$;
import org.mule.weave.v2.sdk.ParsingContextFactory$;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResourceFactory$;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import org.mule.weave.v2.utils.WeaveFile$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;

public final class WeaveBinaryCompiler$ {
    public static WeaveBinaryCompiler$ MODULE$;

    static {
        new WeaveBinaryCompiler$();
    }

    public void toBinary(File resourceDirectory, File outputBaseDirectory, Option<ClassLoader> maybeClassLoader) {
        WeaveBinaryCompiler.FolderBasedResourceResolver folderBasedResourceResolver = new WeaveBinaryCompiler.FolderBasedResourceResolver(resourceDirectory);
        ClassLoaderWeaveResourceResolver classLoaderWeaveResourceResolver = (ClassLoaderWeaveResourceResolver)maybeClassLoader.map((Function1 & Serializable & scala.Serializable)classLoader -> ClassLoaderWeaveResourceResolver$.MODULE$.providedClassLoader((Seq)new .colon.colon(classLoader, (List)Nil$.MODULE$))).getOrElse((Function0 & Serializable & scala.Serializable)() -> ClassLoaderWeaveResourceResolver$.MODULE$.apply());
        Seq loaders = (Seq)new .colon.colon((Object)ModuleLoader$.MODULE$.apply((WeaveResourceResolver)classLoaderWeaveResourceResolver), (List)new .colon.colon((Object)ModuleLoader$.MODULE$.apply((WeaveResourceResolver)folderBasedResourceResolver), (List)Nil$.MODULE$));
        WeaveBinaryCompiler.EnricherModuleLoaderProvider moduleLoaderProvider = new WeaveBinaryCompiler.EnricherModuleLoaderProvider((ClassLoader)maybeClassLoader.getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getClass().getClassLoader()), folderBasedResourceResolver);
        ModuleParsingPhasesManager moduleParsingPhasesManager = ModuleParsingPhasesManager$.MODULE$.apply(ModuleLoaderManager$.MODULE$.apply(loaders, (ModuleLoaderProvider)moduleLoaderProvider));
        RuntimeModuleNodeCompiler runtimeModuleNodeCompiler = RuntimeModuleNodeCompiler$.MODULE$.apply(moduleParsingPhasesManager, RuntimeModuleNodeCompiler$.MODULE$.apply$default$2());
        File x$1 = resourceDirectory;
        File x$2 = resourceDirectory;
        File x$3 = outputBaseDirectory;
        ModuleParsingPhasesManager x$4 = moduleParsingPhasesManager;
        RuntimeModuleNodeCompiler x$5 = runtimeModuleNodeCompiler;
        String x$6 = this.compile$default$1();
        this.compile(x$6, x$1, x$2, x$3, x$4, x$5);
    }

    private void compile(String name, File file2, File resourceDirectory, File outputBaseDirectory, ModuleParsingPhasesManager moduleParsingPhasesManager, RuntimeModuleNodeCompiler runtimeModuleNodeCompiler) {
        File[] files = file2.listFiles();
        if (files != null) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).foreach((Function1 & Serializable & scala.Serializable)file -> {
                if (file.getName().endsWith(WeaveFile$.MODULE$.fileExtension())) {
                    Predef$.MODULE$.println((Object)String.format("Compiling %s", resourceDirectory.toPath().relativize(file.toPath())));
                    String basename = FileHelper$.MODULE$.baseName(file.getName());
                    NameIdentifier identifier = new NameIdentifier(MODULE$.nameIdentifier(name, basename), Option$.MODULE$.empty());
                    ParsingContext parsingContext = ParsingContextFactory$.MODULE$.createParsingContext(identifier, moduleParsingPhasesManager);
                    WeaveResource weaveResource = WeaveResourceFactory$.MODULE$.fromFile(file);
                    DocumentParser documentParser = new DocumentParser(DocumentParser$.MODULE$.$lessinit$greater$default$1(), DocumentParser$.MODULE$.$lessinit$greater$default$2());
                    PhaseResult parseResult = documentParser.parse(weaveResource, parsingContext);
                    if (!parseResult.hasResult() || parseResult.hasErrors()) {
                        Predef$.MODULE$.println((Object)String.format("Errors reported by parser for %s", file.getAbsolutePath()));
                        parseResult.errorMessages().foreach((Function1 & Serializable & scala.Serializable)messages -> {
                            Predef$.MODULE$.println((Object)new StringBuilder(5).append(((Message)messages._2()).message()).append("\nat \n").append(((WeaveLocation)messages._1()).locationString()).toString());
                            return BoxedUnit.UNIT;
                        });
                        throw new RuntimeException("File has compilation errors, it cannot be compiled to binary");
                    }
                    ParsingResult result = (ParsingResult)parseResult.getResult();
                    return MODULE$.binaryCompile((File)file, resourceDirectory, outputBaseDirectory, result.astNode(), weaveResource, parsingContext);
                }
                if (file.isDirectory()) {
                    MODULE$.compile(MODULE$.nameIdentifier(name, file.getName()), (File)file, resourceDirectory, outputBaseDirectory, moduleParsingPhasesManager, runtimeModuleNodeCompiler);
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private String compile$default$1() {
        return "";
    }

    private String nameIdentifier(String name, String moduleName) {
        if (name.isEmpty()) {
            return moduleName;
        }
        return new StringBuilder(0).append(name).append(NameIdentifier$.MODULE$.SEPARATOR()).append(moduleName).toString();
    }

    private File binaryCompile(File file, File resourceDirectory, File outputBaseDirectory, AstNode parserAstNode, WeaveResource weaveResource, ParsingContext parsingContext) {
        PhaseResult phaseResult;
        AstNode astNode = parserAstNode;
        if (astNode instanceof ModuleNode) {
            phaseResult = WeaveCompiler$.MODULE$.preCompileModule(weaveResource, parsingContext);
        } else if (astNode instanceof DocumentNode) {
            phaseResult = WeaveCompiler$.MODULE$.preCompile(weaveResource, parsingContext);
        } else {
            throw new MatchError((Object)astNode);
        }
        PhaseResult preCompilationResultPhaseResult = phaseResult;
        if (!preCompilationResultPhaseResult.hasErrors() && preCompilationResultPhaseResult.hasResult()) {
            DirectivesCapableNode astNode2 = (DirectivesCapableNode)((ParsingResult)preCompilationResultPhaseResult.getResult()).astNode();
            return this.toBinary((AstNode)astNode2, file, resourceDirectory, outputBaseDirectory);
        }
        Predef$.MODULE$.println((Object)new StringBuilder(30).append("Errors reported by parser for ").append(weaveResource.url()).toString());
        preCompilationResultPhaseResult.errorMessages().foreach((Function1 & Serializable & scala.Serializable)messages -> {
            Predef$.MODULE$.println((Object)new StringBuilder(5).append(((Message)messages._2()).message()).append("\nat \n").append(((WeaveLocation)messages._1()).locationString()).toString());
            return BoxedUnit.UNIT;
        });
        throw new RuntimeException("File has compilation errors, it cannot be compiled to binary");
    }

    public File toBinary(AstNode astNode, File file, File resourceDirectory, File outputBaseDirectory) {
        File file2;
        Path relativeWeaveFile = resourceDirectory.toPath().relativize(file.toPath());
        SerializableAstNode serializableAstNode = AstToSerializableMapper$.MODULE$.serialize(astNode);
        Path outputPath = outputBaseDirectory.toPath().resolve(relativeWeaveFile);
        File binaryFile = new File(outputPath.getParent().toFile(), file.getName().replace(WeaveFile$.MODULE$.fileExtension(), WeaveFile$.MODULE$.binaryFileExtension()));
        binaryFile.getParentFile().mkdirs();
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(binaryFile));
        try {
            SerializableAstNodeSerializer$.MODULE$.serialize(serializableAstNode, dataOutputStream);
            file2 = binaryFile;
        }
        catch (Throwable throwable) {
            try {
                dataOutputStream.close();
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        File file3 = file2;
        try {
            dataOutputStream.close();
        }
        catch (Throwable throwable) {}
        return file3;
    }

    public Option<ClassLoader> toBinary$default$3() {
        return Option$.MODULE$.empty();
    }

    public AstNode toAstNode(File binaryFile, WeaveResource sourceWeaveResource, NameIdentifier nameIdentifier) {
        AstNode astNode;
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(binaryFile));
        try {
            astNode = AstToSerializableMapper$.MODULE$.deserialize(WeaveBinaryCompiler$.node$1(dataInputStream), (SerializerContext)new ResourceBasedSerializerContext(sourceWeaveResource, nameIdentifier));
        }
        catch (Throwable throwable) {
            try {
                dataInputStream.close();
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        AstNode astNode2 = astNode;
        try {
            dataInputStream.close();
        }
        catch (Throwable throwable) {}
        return astNode2;
    }

    private static final SerializableAstNode node$1(DataInputStream dataInputStream$1) {
        return SerializableAstNodeSerializer$.MODULE$.deserialize(dataInputStream$1);
    }

    private WeaveBinaryCompiler$() {
        MODULE$ = this;
    }
}

