/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email;

import java.io.IOException;
import java.util.Properties;
import javax.mail.URLName;
import org.mule.api.MuleContext;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.security.TlsIndirectKeyStore;
import org.mule.api.security.TlsIndirectTrustStore;
import org.mule.api.security.tls.TlsConfiguration;
import org.mule.api.security.tls.TlsPropertiesMapper;
import org.mule.transport.email.AbstractRetrieveMailConnector;

public abstract class AbstractTlsRetrieveMailConnector
extends AbstractRetrieveMailConnector
implements TlsIndirectTrustStore,
TlsIndirectKeyStore {
    private String namespace;
    private String socketFactory;
    private String socketFactoryFallback = "false";
    private TlsConfiguration tls = new TlsConfiguration(".keystore");

    protected AbstractTlsRetrieveMailConnector(int defaultPort, String namespace, Class defaultSocketFactory, MuleContext context) {
        super(defaultPort, context);
        this.namespace = namespace;
        this.socketFactory = defaultSocketFactory.getName();
    }

    protected void doInitialise() throws InitialisationException {
        try {
            this.tls.initialise(true, null);
        }
        catch (CreateException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        super.doInitialise();
    }

    protected void extendPropertiesForSession(Properties global, Properties local, URLName url) {
        super.extendPropertiesForSession(global, local, url);
        local.setProperty("mail." + this.getProtocol() + ".ssl", "true");
        local.setProperty("mail." + this.getProtocol() + ".socketFactory.class", this.getSocketFactory());
        local.setProperty("mail." + this.getProtocol() + ".socketFactory.fallback", this.getSocketFactoryFallback());
        new TlsPropertiesMapper(this.namespace).writeToProperties(global, this.tls);
    }

    public String getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(String sslSocketFactory) {
        this.socketFactory = sslSocketFactory;
    }

    public String getSocketFactoryFallback() {
        return this.socketFactoryFallback;
    }

    public void setSocketFactoryFallback(String socketFactoryFallback) {
        this.socketFactoryFallback = socketFactoryFallback;
    }

    public String getTrustStore() {
        return this.tls.getTrustStore();
    }

    public String getTrustStorePassword() {
        return this.tls.getTrustStorePassword();
    }

    public void setTrustStore(String trustStore) throws IOException {
        this.tls.setTrustStore(trustStore);
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.tls.setTrustStorePassword(trustStorePassword);
    }

    public String getClientKeyStore() {
        return this.tls.getClientKeyStore();
    }

    public String getClientKeyStorePassword() {
        return this.tls.getClientKeyStorePassword();
    }

    public String getClientKeyStoreType() {
        return this.tls.getClientKeyStoreType();
    }

    public void setClientKeyStore(String name) throws IOException {
        this.tls.setClientKeyStore(name);
    }

    public void setClientKeyStorePassword(String clientKeyStorePassword) {
        this.tls.setClientKeyStorePassword(clientKeyStorePassword);
    }

    public void setClientKeyStoreType(String clientKeyStoreType) {
        this.tls.setClientKeyStoreType(clientKeyStoreType);
    }
}

