/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.validation.resolver.model;

import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.validation.resolver.model.ProjectDependencyNode;

public class DependenciesFilter {
    private static final String DEFAULT_TYPE = "jar";
    private String classifier;
    private String scope;

    public DependenciesFilter() {
    }

    public DependenciesFilter(String classifier, String scope) {
        this.classifier = classifier;
        this.scope = scope;
    }

    public Set<ArtifactCoordinates> filter(ProjectDependencyNode node) {
        return node.getProject().getDirectDependencies().stream().filter(this.satisfies(this.classifier, this.scope, DEFAULT_TYPE)).collect(Collectors.toSet());
    }

    protected Predicate<ArtifactCoordinates> hasClassifier(String classifier) {
        return dep -> StringUtils.equals((CharSequence)classifier, (CharSequence)dep.getClassifier());
    }

    protected Predicate<ArtifactCoordinates> hasScope(String scope) {
        return dep -> StringUtils.equals((CharSequence)scope, (CharSequence)dep.getScope());
    }

    protected Predicate<ArtifactCoordinates> hasType(String type) {
        return dep -> StringUtils.equals((CharSequence)type, (CharSequence)dep.getType());
    }

    protected Predicate<ArtifactCoordinates> satisfies(String classifier, String scope, String type) {
        return this.hasClassifier(classifier).and(this.hasScope(scope)).and(this.hasType(type));
    }
}

