/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.utils;

import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.meta.MuleVersion;

public class MuleApplicationModelLoader {
    public static final String MULE_ARTIFACT_JSON_FILE_NAME = "mule-artifact.json";
    public static final MuleVersion MIN_MULE_GA_VERSION = new MuleVersion("4.1.1");
    private final MuleApplicationModel muleApplicationModel;
    private String runtimeVersion;
    private final Log log;

    public MuleApplicationModelLoader(MuleApplicationModel muleApplicationModel, Log log) {
        this.muleApplicationModel = muleApplicationModel;
        this.log = log;
    }

    public MuleApplicationModelLoader withRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
        return this;
    }

    public String getRuntimeVersion() {
        if (StringUtils.isNotBlank((CharSequence)this.runtimeVersion)) {
            return this.runtimeVersion;
        }
        String runtimeVersion = this.getMinMuleVersion();
        this.log.debug((CharSequence)("Runtime version set to " + runtimeVersion + " obtained from the " + MULE_ARTIFACT_JSON_FILE_NAME + " file"));
        return runtimeVersion;
    }

    private String getMinMuleVersion() {
        MuleVersion minMuleVersion = new MuleVersion(this.muleApplicationModel.getMinMuleVersion());
        if (minMuleVersion.atLeast(MIN_MULE_GA_VERSION)) {
            return this.muleApplicationModel.getMinMuleVersion();
        }
        return MIN_MULE_GA_VERSION.toCompleteNumericVersion();
    }
}

