/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.deployment;

import org.mule.tools.client.core.exception.DeploymentException;
import org.mule.tools.deployment.Deployer;
import org.mule.tools.deployment.agent.AgentApplicationDeployer;
import org.mule.tools.deployment.agent.AgentDomainDeployer;
import org.mule.tools.deployment.arm.ArmApplicationDeployer;
import org.mule.tools.deployment.arm.ArmDomainDeployer;
import org.mule.tools.deployment.cloudhub.CloudHubApplicationDeployer;
import org.mule.tools.deployment.cloudhub.CloudHubDomainDeployer;
import org.mule.tools.deployment.cloudhub2.Cloudhub2ApplicationDeployer;
import org.mule.tools.deployment.cloudhub2.Cloudhub2DomainDeployer;
import org.mule.tools.deployment.fabric.RuntimeFabricApplicationDeployer;
import org.mule.tools.deployment.fabric.RuntimeFabricDomainDeployer;
import org.mule.tools.deployment.standalone.StandaloneApplicationDeployer;
import org.mule.tools.deployment.standalone.StandaloneDomainDeployer;
import org.mule.tools.model.Deployment;
import org.mule.tools.model.agent.AgentDeployment;
import org.mule.tools.model.anypoint.ArmDeployment;
import org.mule.tools.model.anypoint.CloudHubDeployment;
import org.mule.tools.model.anypoint.Cloudhub2Deployment;
import org.mule.tools.model.anypoint.RuntimeFabricOnPremiseDeployment;
import org.mule.tools.model.standalone.StandaloneDeployment;
import org.mule.tools.utils.DeployerLog;

public abstract class AbstractDeployerFactory {
    public static final String MULE_DOMAIN_CLASSIFIER = "mule-domain";
    public static final String MULE_APPLICATION_CLASSIFIER = "mule-application";
    public static final AgentDeployerFactory AGENT_DEPLOYER_FACTORY = new AgentDeployerFactory();
    public static final ArmDeployerFactory ARM_DEPLOYER_FACTORY = new ArmDeployerFactory();
    public static final CloudHubDeployerFactory CLOUDHUB_DEPLOYER_FACTORY = new CloudHubDeployerFactory();
    public static final StandaloneDeployerFactory STANDALONE_DEPLOYER_FACTORY = new StandaloneDeployerFactory();
    public static final RuntimeFabricDeployerFactory RUNTIME_FABRIC_DEPLOYER_FACTORY = new RuntimeFabricDeployerFactory();
    public static final Cloudub2DeployerFactory CLOUDHUB2_DEPLOYER_FACTORY = new Cloudub2DeployerFactory();

    static AbstractDeployerFactory getDeployerFactory(Deployment deployment) {
        if (deployment instanceof AgentDeployment) {
            return AGENT_DEPLOYER_FACTORY;
        }
        if (deployment instanceof ArmDeployment) {
            return ARM_DEPLOYER_FACTORY;
        }
        if (deployment instanceof CloudHubDeployment) {
            return CLOUDHUB_DEPLOYER_FACTORY;
        }
        if (deployment instanceof StandaloneDeployment) {
            return STANDALONE_DEPLOYER_FACTORY;
        }
        if (deployment instanceof Cloudhub2Deployment) {
            return CLOUDHUB2_DEPLOYER_FACTORY;
        }
        if (deployment instanceof RuntimeFabricOnPremiseDeployment) {
            return RUNTIME_FABRIC_DEPLOYER_FACTORY;
        }
        throw new RuntimeException("Deployment not supported: " + deployment.getClass().getSimpleName());
    }

    public abstract Deployer createArtifactDeployer(Deployment var1, DeployerLog var2) throws DeploymentException;

    protected static class AgentDeployerFactory
    extends AbstractDeployerFactory {
        protected AgentDeployerFactory() {
        }

        @Override
        public Deployer createArtifactDeployer(Deployment deployment, DeployerLog log) {
            switch (deployment.getPackaging()) {
                case "mule-domain": {
                    return new AgentDomainDeployer(deployment, log);
                }
                case "mule-application": {
                    return new AgentApplicationDeployer(deployment, log);
                }
            }
            throw new RuntimeException("Deployment not supported: " + deployment.getClass().getSimpleName());
        }
    }

    protected static class ArmDeployerFactory
    extends AbstractDeployerFactory {
        protected ArmDeployerFactory() {
        }

        @Override
        public Deployer createArtifactDeployer(Deployment deployment, DeployerLog log) throws DeploymentException {
            switch (deployment.getPackaging()) {
                case "mule-domain": {
                    return new ArmDomainDeployer(deployment, log);
                }
                case "mule-application": {
                    return new ArmApplicationDeployer(deployment, log);
                }
            }
            throw new RuntimeException("Deployment not supported: " + deployment.getClass().getSimpleName());
        }
    }

    protected static class CloudHubDeployerFactory
    extends AbstractDeployerFactory {
        protected CloudHubDeployerFactory() {
        }

        @Override
        public Deployer createArtifactDeployer(Deployment deployment, DeployerLog log) {
            switch (deployment.getPackaging()) {
                case "mule-domain": {
                    return new CloudHubDomainDeployer(deployment, log);
                }
                case "mule-application": {
                    return new CloudHubApplicationDeployer(deployment, log);
                }
            }
            throw new RuntimeException("Deployment not supported: " + deployment.getClass().getSimpleName());
        }
    }

    protected static class StandaloneDeployerFactory
    extends AbstractDeployerFactory {
        protected StandaloneDeployerFactory() {
        }

        @Override
        public Deployer createArtifactDeployer(Deployment deployment, DeployerLog log) throws DeploymentException {
            switch (deployment.getPackaging()) {
                case "mule-domain": {
                    return new StandaloneDomainDeployer(deployment, log);
                }
                case "mule-application": {
                    return new StandaloneApplicationDeployer(deployment, log);
                }
            }
            throw new RuntimeException("Deployment not supported: " + deployment.getClass().getSimpleName());
        }
    }

    protected static class Cloudub2DeployerFactory
    extends AbstractDeployerFactory {
        protected Cloudub2DeployerFactory() {
        }

        @Override
        public Deployer createArtifactDeployer(Deployment deployment, DeployerLog log) {
            switch (deployment.getPackaging()) {
                case "mule-domain": {
                    return new Cloudhub2DomainDeployer(deployment, log);
                }
                case "mule-application": {
                    return new Cloudhub2ApplicationDeployer(deployment, log);
                }
            }
            throw new RuntimeException("Deployment not supported: " + deployment.getClass().getSimpleName());
        }
    }

    protected static class RuntimeFabricDeployerFactory
    extends AbstractDeployerFactory {
        protected RuntimeFabricDeployerFactory() {
        }

        @Override
        public Deployer createArtifactDeployer(Deployment deployment, DeployerLog log) {
            switch (deployment.getPackaging()) {
                case "mule-domain": {
                    return new RuntimeFabricDomainDeployer(deployment, log);
                }
                case "mule-application": {
                    return new RuntimeFabricApplicationDeployer(deployment, log);
                }
            }
            throw new RuntimeException("Deployment not supported: " + deployment.getClass().getSimpleName());
        }
    }
}

