/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.classloader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.mule.tools.api.classloader.ArtifactCustomJsonSerializer;
import org.mule.tools.api.classloader.ClassLoaderModelJsonSerializer;
import org.mule.tools.api.classloader.model.AppClassLoaderModel;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ClassLoaderModel;

public class AppClassLoaderModelJsonSerializer
extends ClassLoaderModelJsonSerializer {
    public static AppClassLoaderModel deserialize(File classLoaderModelDescriptor) {
        return AppClassLoaderModelJsonSerializer.deserialize(classLoaderModelDescriptor.toPath());
    }

    public static AppClassLoaderModel deserialize(Path classLoaderModelDescriptor) {
        AppClassLoaderModel appClassLoaderModel;
        block8: {
            BufferedReader reader = Files.newBufferedReader(classLoaderModelDescriptor);
            try {
                Gson gson = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().create();
                AppClassLoaderModel classLoaderModel = (AppClassLoaderModel)gson.fromJson((Reader)reader, AppClassLoaderModel.class);
                AppClassLoaderModelJsonSerializer.validate((ClassLoaderModel)classLoaderModel, classLoaderModelDescriptor);
                appClassLoaderModel = classLoaderModel;
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not create classloader-model.json", e);
                }
            }
            ((Reader)reader).close();
        }
        return appClassLoaderModel;
    }

    public static class AppClassLoaderModelCustomJsonSerializer
    implements JsonSerializer<AppClassLoaderModel> {
        public JsonElement serialize(AppClassLoaderModel classLoaderModel, Type type, JsonSerializationContext jsonSerializationContext) {
            Gson gson = new GsonBuilder().enableComplexMapKeySerialization().registerTypeAdapter(Artifact.class, (Object)new ArtifactCustomJsonSerializer()).create();
            JsonObject jsonObject = (JsonObject)gson.toJsonTree((Object)classLoaderModel);
            if (classLoaderModel.getAdditionalPluginDependencies().map(List::isEmpty).orElse(false).booleanValue()) {
                jsonObject.remove("additionalPluginDependencies");
            } else {
                jsonObject.add("additionalPluginDependencies", jsonObject.remove("additionalPluginDependencies"));
            }
            if (classLoaderModel.getPackages() == null || classLoaderModel.getPackages().length == 0) {
                jsonObject.remove("packages");
            }
            if (classLoaderModel.getResources() == null || classLoaderModel.getResources().length == 0) {
                jsonObject.remove("resources");
            }
            return jsonObject;
        }
    }
}

