/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.json.JSONObject;
import org.mule.common.metadata.AbstractMetaDataModel;
import org.mule.common.metadata.DefaultListMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.DefaultStructuredMetadataModel;
import org.mule.common.metadata.DefaultUnknownMetaDataModel;
import org.mule.common.metadata.JSONMetadataModelFactoryHelper;
import org.mule.common.metadata.JSONSchemaMetaDataFieldFactory;
import org.mule.common.metadata.MetaDataGenerationException;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.parser.json.JSONArrayType;
import org.mule.common.metadata.parser.json.JSONObjectType;
import org.mule.common.metadata.parser.json.JSONPointerType;
import org.mule.common.metadata.parser.json.JSONType;
import org.mule.common.metadata.parser.json.JSONTypeUtils;
import org.mule.common.metadata.parser.json.SchemaEnv;
import org.mule.common.metadata.parser.json.SchemaException;

public class JSONSchemaMetadataModelFactory {
    public static final String OBJECT_ELEMENT_NAME = "object";
    public static final String ARRAY_ELEMENT_NAME = "array";
    public static final String TYPE = "type";
    public static final String PROPERTIES = "properties";
    private final JSONMetadataModelFactoryHelper helper = new JSONMetadataModelFactoryHelper();

    private MetaDataModel buildModel(String jsonSchemaString, URL jsonSchemaURL) {
        try {
            JSONObject jsonSchemaObject = new JSONObject(jsonSchemaString);
            if (jsonSchemaObject.has(TYPE) && jsonSchemaObject.get(TYPE).toString().toLowerCase().equals(ARRAY_ELEMENT_NAME)) {
                JSONArrayType arrayType = new JSONArrayType(new SchemaEnv(jsonSchemaObject, jsonSchemaURL), jsonSchemaObject);
                JSONType itemsType = arrayType.getItemsType();
                if (itemsType.isJSONObject()) {
                    DefaultStructuredMetadataModel model = new DefaultStructuredMetadataModel(DataType.JSON, new JSONSchemaMetaDataFieldFactory((JSONObjectType)itemsType, this.helper));
                    return new DefaultListMetaDataModel(model);
                }
                if (itemsType.isJSONPointer()) {
                    AbstractMetaDataModel model = this.helper.buildJSONPointerMetaDataModel((JSONPointerType)itemsType);
                    return new DefaultListMetaDataModel(model);
                }
                if (itemsType.isJSONPrimitive()) {
                    DataType dataType = JSONTypeUtils.getDataType(itemsType);
                    AbstractMetaDataModel model = dataType == DataType.UNKNOWN ? new DefaultUnknownMetaDataModel() : new DefaultSimpleMetaDataModel(dataType);
                    return new DefaultListMetaDataModel(model);
                }
                DefaultUnknownMetaDataModel model = new DefaultUnknownMetaDataModel();
                return new DefaultListMetaDataModel(model);
            }
            if (new SchemaEnv(null, jsonSchemaObject).evaluate(jsonSchemaObject).isJSONPointer()) {
                JSONPointerType pointer = (JSONPointerType)new SchemaEnv(null, jsonSchemaObject).evaluate(jsonSchemaObject);
                return this.helper.buildJSONPointerMetaDataModel(pointer);
            }
            if (jsonSchemaObject.has(TYPE) && jsonSchemaObject.get(TYPE).toString().toLowerCase().equals(OBJECT_ELEMENT_NAME) || jsonSchemaObject.has(PROPERTIES)) {
                JSONSchemaMetaDataFieldFactory fieldFactory = new JSONSchemaMetaDataFieldFactory(new JSONObjectType(new SchemaEnv(jsonSchemaObject, jsonSchemaURL), jsonSchemaObject), this.helper);
                return new DefaultStructuredMetadataModel(DataType.JSON, fieldFactory);
            }
            if (new SchemaEnv().evaluate(jsonSchemaObject).isJSONPrimitive()) {
                JSONType simpleType = new SchemaEnv().evaluate(jsonSchemaObject);
                DataType dataType = JSONTypeUtils.getDataType(simpleType);
                return dataType == DataType.UNKNOWN ? new DefaultUnknownMetaDataModel() : new DefaultSimpleMetaDataModel(dataType);
            }
            return new DefaultUnknownMetaDataModel();
        }
        catch (SchemaException e) {
            throw new MetaDataGenerationException(e);
        }
    }

    public MetaDataModel buildModel(String jsonSchemaString) {
        return this.buildModel(jsonSchemaString, null);
    }

    public MetaDataModel buildModel(URL url) throws IOException {
        String jsonSchemaString = IOUtils.toString((InputStream)url.openStream());
        return this.buildModel(jsonSchemaString, url);
    }
}

