/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata;

import java.util.HashMap;
import java.util.Map;
import org.mule.common.metadata.AbstractMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.DefaultStructuredMetadataModel;
import org.mule.common.metadata.DefaultUnknownMetaDataModel;
import org.mule.common.metadata.JSONSchemaMetaDataFieldFactory;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.parser.json.JSONArrayType;
import org.mule.common.metadata.parser.json.JSONObjectType;
import org.mule.common.metadata.parser.json.JSONPointerType;
import org.mule.common.metadata.parser.json.JSONType;
import org.mule.common.metadata.parser.json.JSONTypeUtils;

class JSONMetadataModelFactoryHelper {
    private final Map<JSONObjectType, DefaultStructuredMetadataModel> visitedTypes;

    public JSONMetadataModelFactoryHelper(Map<JSONObjectType, DefaultStructuredMetadataModel> visitedTypes) {
        this.visitedTypes = visitedTypes;
    }

    public JSONMetadataModelFactoryHelper() {
        this(new HashMap<JSONObjectType, DefaultStructuredMetadataModel>());
    }

    public AbstractMetaDataModel buildJSONArrayMetaDataModel(JSONArrayType property) {
        AbstractMetaDataModel model = null;
        JSONType itemsType = property.getItemsType();
        if (itemsType.isJSONPrimitive()) {
            DataType dataType = JSONTypeUtils.getDataType(itemsType);
            model = dataType == DataType.UNKNOWN ? new DefaultUnknownMetaDataModel() : new DefaultSimpleMetaDataModel(dataType);
        } else if (itemsType.isJSONPointer()) {
            model = this.buildJSONPointerMetaDataModel((JSONPointerType)itemsType);
        } else if (itemsType.isJSONObject()) {
            model = this.buildJSONMetaDataModel((JSONObjectType)itemsType);
        }
        return model;
    }

    public AbstractMetaDataModel buildJSONPointerMetaDataModel(JSONPointerType pointer) {
        JSONType resolvedType = pointer.resolve();
        if (resolvedType.isJSONArray()) {
            return this.buildJSONArrayMetaDataModel((JSONArrayType)resolvedType);
        }
        if (resolvedType.isJSONObject()) {
            return this.buildJSONMetaDataModel((JSONObjectType)resolvedType);
        }
        if (resolvedType.isJSONPointer()) {
            return this.buildJSONPointerMetaDataModel((JSONPointerType)resolvedType);
        }
        if (resolvedType.isJSONPrimitive()) {
            DataType dataType = JSONTypeUtils.getDataType(resolvedType);
            return dataType == DataType.UNKNOWN ? new DefaultUnknownMetaDataModel() : new DefaultSimpleMetaDataModel(dataType);
        }
        return null;
    }

    public DefaultStructuredMetadataModel buildJSONMetaDataModel(JSONObjectType type) {
        DefaultStructuredMetadataModel model;
        if (this.visitedTypes.containsKey(type)) {
            model = this.visitedTypes.get(type);
        } else {
            model = new DefaultStructuredMetadataModel(DataType.JSON);
            this.visitedTypes.put(type, model);
            model.loadFieldsFrom(new JSONSchemaMetaDataFieldFactory(type, this));
        }
        return model;
    }
}

